/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi;

import java.util.ArrayList;
import java.util.List;
import org.embulk.spi.Buffer;
import org.embulk.spi.FileOutput;

public class MockFileOutput
implements FileOutput {
    private List<List<Buffer>> files = new ArrayList<List<Buffer>>();
    private List<Buffer> lastBuffers = null;
    private boolean finished = false;
    private boolean closed = false;

    public List<List<Buffer>> getFiles() {
        return this.files;
    }

    public List<Buffer> getLastBuffers() {
        return this.lastBuffers;
    }

    public void nextFile() {
        this.lastBuffers = new ArrayList<Buffer>();
        this.files.add(this.lastBuffers);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void add(Buffer buffer) {
        if (this.lastBuffers == null) {
            throw new IllegalStateException("FileOutput.nextFile is not called");
        }
        if (this.finished) {
            throw new IllegalStateException("FileOutput is already finished");
        }
        if (this.closed) {
            throw new IllegalStateException("FileOutput is already closed");
        }
        this.lastBuffers.add(buffer);
    }

    public void finish() {
        this.finished = true;
    }

    public void close() {
        this.closed = true;
    }
}

