/*
 * Decompiled with CFR 0.152.
 */
package org.embulk;

import java.util.Collection;
import java.util.Random;
import org.embulk.EmbulkEmbed;
import org.embulk.RandomManager;
import org.embulk.config.ModelManager;
import org.embulk.deps.buffer.PooledBufferAllocator;
import org.embulk.exec.SimpleTempFileSpaceAllocator;
import org.embulk.plugin.PluginClassLoaderFactory;
import org.embulk.plugin.PluginClassLoaderFactoryImpl;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.ExecAction;
import org.embulk.spi.ExecInternal;
import org.embulk.spi.ExecSessionInternal;
import org.embulk.spi.MockFormatterPlugin;
import org.embulk.spi.MockParserPlugin;
import org.embulk.spi.TempFileSpaceAllocator;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class EmbulkTestRuntime
implements TestRule {
    private ExecSessionInternal exec;
    private final RandomManager random = new RandomManager();

    private void reset() {
        this.exec = null;
    }

    public ExecSessionInternal getExec() {
        if (this.exec == null) {
            ModelManager model = EmbulkTestRuntime.createModelManager();
            this.exec = ExecSessionInternal.builderInternal((BufferAllocator)PooledBufferAllocator.create(), (TempFileSpaceAllocator)new SimpleTempFileSpaceAllocator()).setModelManager(model).registerParserPlugin("mock", MockParserPlugin.class).registerFormatterPlugin("mock", MockFormatterPlugin.class).build();
        }
        return this.exec;
    }

    public BufferAllocator getBufferAllocator() {
        return this.getExec().getBufferAllocator();
    }

    public ModelManager getModelManager() {
        return this.getExec().getModelManager();
    }

    public Random getRandom() {
        return this.random.getRandom();
    }

    public static PluginClassLoaderFactory buildPluginClassLoaderFactory() {
        return PluginClassLoaderFactoryImpl.of((Collection)EmbulkEmbed.PARENT_FIRST_PACKAGES, (Collection)EmbulkEmbed.PARENT_FIRST_RESOURCES);
    }

    public Statement apply(Statement base, Description description) {
        final Statement statement = new EmbulkTestWatcher().apply(base, description);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    ExecInternal.doWith((ExecSessionInternal)EmbulkTestRuntime.this.getExec(), (ExecAction)new ExecAction<Void>(){

                        public Void run() {
                            try {
                                statement.evaluate();
                            }
                            catch (Throwable ex) {
                                throw new RuntimeExecutionException(ex);
                            }
                            return null;
                        }
                    });
                }
                catch (RuntimeException ex) {
                    throw ex.getCause();
                }
                finally {
                    EmbulkTestRuntime.this.getExec().cleanup();
                }
            }
        };
    }

    private static ModelManager createModelManager() {
        return new ModelManager();
    }

    private static class RuntimeExecutionException
    extends RuntimeException {
        public RuntimeExecutionException(Throwable cause) {
            super(cause);
        }
    }

    private class EmbulkTestWatcher
    extends TestWatcher {
        private EmbulkTestWatcher() {
        }

        protected void starting(Description description) {
            EmbulkTestRuntime.this.reset();
        }
    }
}

