/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.embulk.EmbulkEmbed;
import org.embulk.EmbulkSystemProperties;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigLoader;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.exec.BulkLoader;
import org.embulk.exec.PreviewResult;
import org.embulk.spi.ColumnConfig;
import org.embulk.spi.DecoderPlugin;
import org.embulk.spi.EncoderPlugin;
import org.embulk.spi.ExecutorPlugin;
import org.embulk.spi.FileInputPlugin;
import org.embulk.spi.FileOutputPlugin;
import org.embulk.spi.FilterPlugin;
import org.embulk.spi.FormatterPlugin;
import org.embulk.spi.GuessPlugin;
import org.embulk.spi.InputPlugin;
import org.embulk.spi.OutputPlugin;
import org.embulk.spi.ParserPlugin;
import org.embulk.spi.Schema;
import org.embulk.spi.SchemaConfig;
import org.embulk.spi.TempFileException;
import org.embulk.spi.TempFileSpace;
import org.embulk.spi.TempFileSpaceImpl;
import org.embulk.test.EmbulkTests;
import org.embulk.test.PreviewResultInputPlugin;
import org.embulk.test.TestingBulkLoader;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestingEmbulk
implements TestRule {
    private final EmbulkSystemProperties embulkSystemProperties;
    private final LinkedHashMap<Class<?>, LinkedHashMap<String, Class<?>>> builtinPlugins;
    private EmbulkEmbed embed;
    private TempFileSpace tempFiles;
    private static final List<String> SUPPORTED_TYPES = ImmutableList.of((Object)"boolean", (Object)"long", (Object)"double", (Object)"string", (Object)"timestamp", (Object)"json");

    public static Builder builder() {
        return new Builder();
    }

    TestingEmbulk(Builder builder) {
        this.builtinPlugins = builder.builtinPlugins;
        this.embulkSystemProperties = builder.embulkSystemProperties != null ? EmbulkSystemProperties.of((Properties)builder.embulkSystemProperties) : EmbulkSystemProperties.of((Properties)new Properties());
        this.reset();
    }

    public void reset() {
        this.destroy();
        EmbulkEmbed.Bootstrap bootstrap = new EmbulkEmbed.Bootstrap();
        bootstrap.setEmbulkSystemProperties((Properties)this.embulkSystemProperties);
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(DecoderPlugin.class).entrySet()) {
            bootstrap.builtinDecoderPlugin(plugin.getKey(), plugin.getValue());
        }
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(EncoderPlugin.class).entrySet()) {
            bootstrap.builtinEncoderPlugin(plugin.getKey(), plugin.getValue());
        }
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(ExecutorPlugin.class).entrySet()) {
            bootstrap.builtinExecutorPlugin(plugin.getKey(), plugin.getValue());
        }
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(FileInputPlugin.class).entrySet()) {
            bootstrap.builtinFileInputPlugin(plugin.getKey(), plugin.getValue());
        }
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(FileOutputPlugin.class).entrySet()) {
            bootstrap.builtinFileOutputPlugin(plugin.getKey(), plugin.getValue());
        }
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(FilterPlugin.class).entrySet()) {
            bootstrap.builtinFilterPlugin(plugin.getKey(), plugin.getValue());
        }
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(FormatterPlugin.class).entrySet()) {
            bootstrap.builtinFormatterPlugin(plugin.getKey(), plugin.getValue());
        }
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(GuessPlugin.class).entrySet()) {
            bootstrap.builtinGuessPlugin(plugin.getKey(), plugin.getValue());
        }
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(InputPlugin.class).entrySet()) {
            bootstrap.builtinInputPlugin(plugin.getKey(), plugin.getValue());
        }
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(OutputPlugin.class).entrySet()) {
            bootstrap.builtinOutputPlugin(plugin.getKey(), plugin.getValue());
        }
        for (Map.Entry<String, Class<?>> plugin : this.builtinPlugins.get(ParserPlugin.class).entrySet()) {
            bootstrap.builtinParserPlugin(plugin.getKey(), plugin.getValue());
        }
        this.embed = bootstrap.builtinInputPlugin("preview_result", PreviewResultInputPlugin.class).setAlternativeBulkLoader((BulkLoader)new TestingBulkLoader(this.embulkSystemProperties)).initializeCloseable();
        try {
            this.tempFiles = TempFileSpaceImpl.with((Path)Files.createTempDirectory("embulk-test-temp-", new FileAttribute[0]), (String)"foo");
        }
        catch (IOException ex) {
            throw new TempFileException(ex);
        }
    }

    public void destroy() {
        if (this.embed != null) {
            this.embed = null;
        }
        if (this.tempFiles != null) {
            this.tempFiles.cleanup();
            this.tempFiles = null;
        }
    }

    public Statement apply(Statement base, Description description) {
        return new EmbulkTestingEmbedWatcher().apply(base, description);
    }

    public Path createTempFile(String suffix) {
        return this.tempFiles.createTempFile(suffix).toPath();
    }

    public ConfigLoader configLoader() {
        return this.embed.newConfigLoader();
    }

    public ConfigSource newConfig() {
        return this.configLoader().newConfigSource();
    }

    public ConfigSource loadYamlResource(String name) {
        return this.configLoader().fromYamlString(EmbulkTests.readResource(name));
    }

    private PreviewResult buildPreviewResultWithOutput(PreviewResult result, Path outputDir, Path outputPath) throws IOException {
        this.copyToPath(outputDir, outputPath);
        return result;
    }

    private RunResult buildRunResultWithOutput(RunResult result, Path outputDir, Path outputPath) throws IOException {
        this.copyToPath(outputDir, outputPath);
        return result;
    }

    private void copyToPath(Path outputDir, Path outputPath) throws IOException {
        try (OutputStream out = Files.newOutputStream(outputPath, new OpenOption[0]);){
            ArrayList<Path> fragments = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(outputDir, "fragments_*.csv");){
                for (Path fragment : stream) {
                    fragments.add(fragment);
                }
            }
            Collections.sort(fragments);
            for (Path fragment : fragments) {
                InputStream in = Files.newInputStream(fragment, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    ByteStreams.copy((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    public InputBuilder inputBuilder() {
        return new InputBuilder();
    }

    public ParserBuilder parserBuilder() {
        return new ParserBuilder();
    }

    public OutputBuilder outputBuilder() {
        return new OutputBuilder();
    }

    public RunResult runParser(ConfigSource parserConfig, Path inputPath, Path outputPath) throws IOException {
        return this.parserBuilder().parser(parserConfig).inputPath(inputPath).outputPath(outputPath).run();
    }

    public RunResult runParser(ConfigSource parserConfig, Path inputPath, Path outputPath, ConfigSource execConfig) throws IOException {
        return this.parserBuilder().parser(parserConfig).inputPath(inputPath).outputPath(outputPath).exec(execConfig).run();
    }

    public RunResult runInput(ConfigSource inConfig, Path outputPath) throws IOException {
        return this.inputBuilder().in(inConfig).outputPath(outputPath).run();
    }

    public RunResult runInput(ConfigSource inConfig, Path outputPath, ConfigSource execConfig) throws IOException {
        return this.inputBuilder().exec(execConfig).in(inConfig).outputPath(outputPath).run();
    }

    public RunResult runOutput(ConfigSource outConfig, Path inputPath) throws IOException {
        return this.outputBuilder().out(outConfig).inputPath(inputPath).run();
    }

    public RunResult runOutput(ConfigSource outConfig, Path inputPath, ConfigSource execConfig) throws IOException {
        return this.outputBuilder().exec(execConfig).out(outConfig).inputPath(inputPath).run();
    }

    public ConfigDiff guessInput(ConfigSource inSeedConfig) {
        return this.inputBuilder().in(inSeedConfig).guess();
    }

    public ConfigDiff guessInput(ConfigSource inSeedConfig, ConfigSource execConfig) {
        return this.inputBuilder().exec(execConfig).in(inSeedConfig).guess();
    }

    public ConfigDiff guessParser(Path inputPath) {
        return this.parserBuilder().inputPath(inputPath).guess();
    }

    public ConfigDiff guessParser(ConfigSource parserSeedConfig, Path inputPath) {
        return this.parserBuilder().parser(parserSeedConfig).inputPath(inputPath).guess();
    }

    public ConfigDiff guessParser(ConfigSource parserSeedConfig, Path inputPath, ConfigSource execConfig) {
        return this.parserBuilder().parser(parserSeedConfig).inputPath(inputPath).exec(execConfig).guess();
    }

    public class OutputBuilder {
        private ConfigSource outConfig = null;
        private ConfigSource execConfig = TestingEmbulk.this.newConfig();
        private Path inputPath;
        private SchemaConfig inputSchema;

        public OutputBuilder out(ConfigSource outConfig) {
            Preconditions.checkNotNull((Object)outConfig, (Object)"outConfig");
            this.outConfig = outConfig;
            return this;
        }

        public OutputBuilder exec(ConfigSource execConfig) {
            Preconditions.checkNotNull((Object)execConfig, (Object)"execConfig");
            this.execConfig = execConfig;
            return this;
        }

        public OutputBuilder inputPath(Path inputPath) {
            Preconditions.checkNotNull((Object)inputPath, (Object)"inputPath");
            this.inputPath = inputPath;
            return this;
        }

        public OutputBuilder inputResource(String resourceName) throws IOException {
            Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName");
            Path path = TestingEmbulk.this.createTempFile("csv");
            EmbulkTests.copyResource(resourceName, path);
            return this.inputPath(path);
        }

        public OutputBuilder inputSchema(SchemaConfig inputSchema) {
            Preconditions.checkNotNull((Object)inputSchema, (Object)"inputSchema");
            this.inputSchema = inputSchema;
            return this;
        }

        public RunResult run() throws IOException {
            Preconditions.checkState((this.outConfig != null ? 1 : 0) != 0, (Object)"out config must be set");
            Preconditions.checkState((this.inputPath != null ? 1 : 0) != 0, (Object)"inputPath must be set");
            String fileName = this.inputPath.toAbsolutePath().toString();
            Preconditions.checkArgument((boolean)fileName.endsWith(".csv"), (Object)"inputPath must end with .csv");
            this.execConfig.set("min_output_tasks", (Object)1);
            ConfigSource inConfig = TestingEmbulk.this.newConfig().set("type", (Object)"file").set("path_prefix", (Object)fileName).set("parser", (Object)this.newParserConfig());
            ConfigSource config = TestingEmbulk.this.newConfig().set("exec", (Object)this.execConfig).set("in", (Object)inConfig).set("out", (Object)this.outConfig);
            return (RunResult)TestingEmbulk.this.embed.run(config);
        }

        private ConfigSource newParserConfig() {
            return TestingEmbulk.this.newConfig().set("charset", (Object)"UTF-8").set("newline", (Object)"LF").set("type", (Object)"csv").set("delimiter", (Object)",").set("quote", (Object)"\"").set("escape", (Object)"\"").set("skip_header_lines", (Object)1).set("columns", (Object)this.newSchemaConfig());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private SchemaConfig newSchemaConfig() {
            ImmutableList.Builder schema = ImmutableList.builder();
            try (BufferedReader reader = Files.newBufferedReader(this.inputPath, StandardCharsets.UTF_8);){
                for (String column : reader.readLine().split(",")) {
                    ColumnConfig columnConfig = this.newColumnConfig(column);
                    if (columnConfig == null) continue;
                    schema.add((Object)columnConfig);
                }
                SchemaConfig schemaConfig = new SchemaConfig((List)schema.build());
                return schemaConfig;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ColumnConfig newColumnConfig(String column) {
            String[] tuple = column.split(":", 2);
            Preconditions.checkArgument((tuple.length == 2 ? 1 : 0) != 0, (Object)"tuple must be a pair of column name and type");
            String type = tuple[1];
            if (!SUPPORTED_TYPES.contains(type)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unknown column type %s. Supported types are boolean, long, double, string, timestamp and json: %s", tuple[1], column));
            }
            return new ColumnConfig(TestingEmbulk.this.newConfig().set("name", (Object)tuple[0]).set("type", (Object)type));
        }
    }

    public class ParserBuilder {
        private ConfigSource parserConfig;
        private ConfigSource execConfig;
        private Path inputPath;
        private Path outputPath;

        private ParserBuilder() {
            this.parserConfig = TestingEmbulk.this.newConfig();
            this.execConfig = TestingEmbulk.this.newConfig();
            this.inputPath = null;
            this.outputPath = null;
        }

        public ParserBuilder parser(ConfigSource parserConfig) {
            Preconditions.checkNotNull((Object)parserConfig, (Object)"parserConfig");
            this.parserConfig = parserConfig.deepCopy();
            return this;
        }

        public ParserBuilder exec(ConfigSource execConfig) {
            Preconditions.checkNotNull((Object)execConfig, (Object)"execConfig");
            this.execConfig = execConfig.deepCopy();
            return this;
        }

        public ParserBuilder inputPath(Path inputPath) {
            Preconditions.checkNotNull((Object)inputPath, (Object)"inputPath");
            this.inputPath = inputPath;
            return this;
        }

        public ParserBuilder inputResource(String resourceName) throws IOException {
            Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName");
            Path path = TestingEmbulk.this.createTempFile("csv");
            EmbulkTests.copyResource(resourceName, path);
            return this.inputPath(path);
        }

        public ParserBuilder outputPath(Path outputPath) {
            Preconditions.checkNotNull((Object)outputPath, (Object)"outputPath");
            this.outputPath = outputPath;
            return this;
        }

        public ConfigDiff guess() {
            Preconditions.checkState((this.inputPath != null ? 1 : 0) != 0, (Object)"inputPath must be set");
            ConfigSource inConfig = TestingEmbulk.this.newConfig().set("type", (Object)"file").set("path_prefix", (Object)this.inputPath.toAbsolutePath().toString());
            inConfig.set("parser", (Object)this.parserConfig);
            ConfigSource config = TestingEmbulk.this.newConfig().set("exec", (Object)this.execConfig).set("in", (Object)inConfig);
            return TestingEmbulk.this.embed.guess(config).getNested("in").getNested("parser");
        }

        public RunResult run() throws IOException {
            Preconditions.checkState((this.parserConfig != null ? 1 : 0) != 0, (Object)"parser config must be set");
            Preconditions.checkState((this.inputPath != null ? 1 : 0) != 0, (Object)"inputPath must be set");
            Preconditions.checkState((this.outputPath != null ? 1 : 0) != 0, (Object)"outputPath must be set");
            String fileName = this.outputPath.getFileName().toString();
            Preconditions.checkArgument((boolean)fileName.endsWith(".csv"), (Object)"outputPath must end with .csv");
            Path dir = this.outputPath.getParent().resolve(fileName.substring(0, fileName.length() - 4));
            Files.createDirectories(dir, new FileAttribute[0]);
            ConfigSource inConfig = TestingEmbulk.this.newConfig().set("type", (Object)"file").set("path_prefix", (Object)this.inputPath.toAbsolutePath().toString());
            inConfig.set("parser", (Object)this.parserConfig);
            this.execConfig.set("min_output_tasks", (Object)1);
            ConfigSource outConfig = TestingEmbulk.this.newConfig().set("type", (Object)"file").set("path_prefix", (Object)dir.resolve("fragments_").toString()).set("file_ext", (Object)"csv").set("formatter", (Object)TestingEmbulk.this.newConfig().set("type", (Object)"csv").set("header_line", (Object)false).set("newline", (Object)"LF"));
            ConfigSource config = TestingEmbulk.this.newConfig().set("exec", (Object)this.execConfig).set("in", (Object)inConfig).set("out", (Object)outConfig);
            RunResult result = (RunResult)TestingEmbulk.this.embed.run(config);
            return TestingEmbulk.this.buildRunResultWithOutput(result, dir, this.outputPath);
        }
    }

    public class InputBuilder {
        private ConfigSource inConfig = null;
        private List<ConfigSource> filtersConfig = ImmutableList.of();
        private ConfigSource execConfig = TestingEmbulk.this.newConfig();
        private Path outputPath = null;

        private InputBuilder() {
        }

        public InputBuilder in(ConfigSource inConfig) {
            Preconditions.checkNotNull((Object)inConfig, (Object)"inConfig");
            this.inConfig = inConfig.deepCopy();
            return this;
        }

        public InputBuilder filters(List<ConfigSource> filtersConfig) {
            Preconditions.checkNotNull(filtersConfig, (Object)"filtersConfig");
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ConfigSource filter : filtersConfig) {
                builder.add((Object)filter.deepCopy());
            }
            this.filtersConfig = builder.build();
            return this;
        }

        public InputBuilder exec(ConfigSource execConfig) {
            Preconditions.checkNotNull((Object)execConfig, (Object)"execConfig");
            this.execConfig = execConfig.deepCopy();
            return this;
        }

        public InputBuilder outputPath(Path outputPath) {
            Preconditions.checkNotNull((Object)outputPath, (Object)"outputPath");
            this.outputPath = outputPath;
            return this;
        }

        public ConfigDiff guess() {
            Preconditions.checkState((this.inConfig != null ? 1 : 0) != 0, (Object)"in config must be set");
            ConfigSource config = TestingEmbulk.this.newConfig().set("exec", (Object)this.execConfig).set("in", (Object)this.inConfig).set("filters", this.filtersConfig);
            return TestingEmbulk.this.embed.guess(config).getNested("in");
        }

        public PreviewResult preview() throws IOException {
            Preconditions.checkState((this.inConfig != null ? 1 : 0) != 0, (Object)"inputPath must be set");
            Preconditions.checkState((this.outputPath != null ? 1 : 0) != 0, (Object)"outputPath must be set");
            ConfigSource previewConfig = TestingEmbulk.this.newConfig().set("exec", (Object)this.execConfig.set("min_output_tasks", (Object)1)).set("in", (Object)this.inConfig).set("filters", this.filtersConfig);
            PreviewResult result = TestingEmbulk.this.embed.preview(previewConfig);
            PreviewResultInputPlugin.setPreviewResult(result);
            String fileName = this.outputPath.getFileName().toString();
            Preconditions.checkArgument((boolean)fileName.endsWith(".csv"), (Object)"outputPath must end with .csv");
            Path dir = this.outputPath.getParent().resolve(fileName.substring(0, fileName.length() - 4));
            Files.createDirectories(dir, new FileAttribute[0]);
            ConfigSource runConfig = TestingEmbulk.this.newConfig().set("in", (Object)TestingEmbulk.this.newConfig().set("type", (Object)"preview_result")).set("out", (Object)TestingEmbulk.this.newConfig().set("type", (Object)"file").set("path_prefix", (Object)dir.resolve("fragments_").toString()).set("file_ext", (Object)"csv").set("formatter", (Object)TestingEmbulk.this.newConfig().set("type", (Object)"csv").set("header_line", (Object)false).set("newline", (Object)"LF")));
            TestingEmbulk.this.embed.run(runConfig);
            return TestingEmbulk.this.buildPreviewResultWithOutput(result, dir, this.outputPath);
        }

        public RunResult run() throws IOException {
            Preconditions.checkState((this.inConfig != null ? 1 : 0) != 0, (Object)"in config must be set");
            Preconditions.checkState((this.outputPath != null ? 1 : 0) != 0, (Object)"outputPath must be set");
            String fileName = this.outputPath.getFileName().toString();
            Preconditions.checkArgument((boolean)fileName.endsWith(".csv"), (Object)"outputPath must end with .csv");
            Path dir = this.outputPath.getParent().resolve(fileName.substring(0, fileName.length() - 4));
            Files.createDirectories(dir, new FileAttribute[0]);
            this.execConfig.set("min_output_tasks", (Object)1);
            ConfigSource outConfig = TestingEmbulk.this.newConfig().set("type", (Object)"file").set("path_prefix", (Object)dir.resolve("fragments_").toString()).set("file_ext", (Object)"csv").set("formatter", (Object)TestingEmbulk.this.newConfig().set("type", (Object)"csv").set("header_line", (Object)false).set("newline", (Object)"LF"));
            ConfigSource config = TestingEmbulk.this.newConfig().set("exec", (Object)this.execConfig).set("in", (Object)this.inConfig).set("filters", this.filtersConfig).set("out", (Object)outConfig);
            RunResult result = (RunResult)TestingEmbulk.this.embed.run(config);
            return TestingEmbulk.this.buildRunResultWithOutput(result, dir, this.outputPath);
        }
    }

    public static interface RunResult {
        public ConfigDiff getConfigDiff();

        public List<Throwable> getIgnoredExceptions();

        public Schema getInputSchema();

        public Schema getOutputSchema();

        public List<TaskReport> getInputTaskReports();

        public List<TaskReport> getOutputTaskReports();
    }

    private class EmbulkTestingEmbedWatcher
    extends TestWatcher {
        private EmbulkTestingEmbedWatcher() {
        }

        protected void starting(Description description) {
            TestingEmbulk.this.reset();
        }
    }

    public static class Builder {
        private Properties embulkSystemProperties = null;
        private LinkedHashMap<Class<?>, LinkedHashMap<String, Class<?>>> builtinPlugins = new LinkedHashMap();

        Builder() {
            this.builtinPlugins.put(DecoderPlugin.class, new LinkedHashMap());
            this.builtinPlugins.put(EncoderPlugin.class, new LinkedHashMap());
            this.builtinPlugins.put(ExecutorPlugin.class, new LinkedHashMap());
            this.builtinPlugins.put(FileInputPlugin.class, new LinkedHashMap());
            this.builtinPlugins.put(FileOutputPlugin.class, new LinkedHashMap());
            this.builtinPlugins.put(FilterPlugin.class, new LinkedHashMap());
            this.builtinPlugins.put(FormatterPlugin.class, new LinkedHashMap());
            this.builtinPlugins.put(GuessPlugin.class, new LinkedHashMap());
            this.builtinPlugins.put(InputPlugin.class, new LinkedHashMap());
            this.builtinPlugins.put(OutputPlugin.class, new LinkedHashMap());
            this.builtinPlugins.put(ParserPlugin.class, new LinkedHashMap());
        }

        public <T> Builder registerPlugin(Class<T> iface, String name, Class<?> impl) {
            this.builtinPlugins.get(iface).put(name, impl);
            return this;
        }

        public <T> Builder setEmbulkSystemProperties(Properties properties) {
            this.embulkSystemProperties = properties;
            return this;
        }

        public TestingEmbulk build() {
            return new TestingEmbulk(this);
        }
    }
}

