/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.test;

import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.embulk.config.ConfigLoader;
import org.embulk.config.ConfigSource;
import org.embulk.config.ModelManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;

public class EmbulkTests {
    private EmbulkTests() {
    }

    public static ConfigSource config(String envName) {
        String path = System.getenv(envName);
        Assume.assumeThat((Object)Strings.isNullOrEmpty((String)path), (Matcher)Matchers.is((Object)false));
        try {
            return new ConfigLoader(new ModelManager()).fromYamlFile(new File(path));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readResource(String name) {
        try (InputStream in = Resources.getResource((String)name).openStream();){
            String string = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void copyResource(String resource, Path dest) throws IOException {
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        try (InputStream input = Resources.getResource((String)resource).openStream();){
            Files.copy(input, dest, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static String readFile(Path path) throws IOException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            String string = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
            return string;
        }
    }

    public static String readSortedFile(Path path) throws IOException {
        List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
        Collections.sort(lines);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }
}

