/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi;

import java.time.Instant;
import java.util.List;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.Page;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.PageOutput;
import org.embulk.spi.Schema;
import org.embulk.spi.TestPageBuilderReader;
import org.embulk.spi.time.Timestamp;
import org.msgpack.value.Value;

public class PageTestUtils {
    private PageTestUtils() {
    }

    public static List<Page> buildPage(BufferAllocator bufferAllocator, Schema schema, Object ... values) {
        TestPageBuilderReader.MockPageOutput output = new TestPageBuilderReader.MockPageOutput();
        try (PageBuilder builder = new PageBuilder(bufferAllocator, schema, (PageOutput)output);){
            int idx = 0;
            while (idx < values.length) {
                for (int column = 0; column < builder.getSchema().getColumnCount(); ++column) {
                    Object value;
                    if ((value = values[idx++]) == null) {
                        builder.setNull(column);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        builder.setBoolean(column, ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (value instanceof Double) {
                        builder.setDouble(column, ((Double)value).doubleValue());
                        continue;
                    }
                    if (value instanceof Long) {
                        builder.setLong(column, ((Long)value).longValue());
                        continue;
                    }
                    if (value instanceof String) {
                        builder.setString(column, (String)value);
                        continue;
                    }
                    if (value instanceof Timestamp) {
                        builder.setTimestamp(column, (Timestamp)value);
                        continue;
                    }
                    if (value instanceof Instant) {
                        builder.setTimestamp(column, (Instant)value);
                        continue;
                    }
                    if (value instanceof Value) {
                        builder.setJson(column, (Value)value);
                        continue;
                    }
                    throw new IllegalStateException("Unsupported type in test utils: " + value.toString());
                }
                builder.addRecord();
            }
            builder.finish();
        }
        return output.pages;
    }
}

