/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.spi.Exec;
import org.embulk.spi.FileInputPlugin;
import org.embulk.spi.TransactionalFileInput;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.embulk.util.file.InputStreamFileInput;
import org.embulk.util.file.InputStreamTransactionalFileInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileInputPlugin
implements FileInputPlugin {
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();
    private static final Path WORKING_DIRECTORY = Paths.get("", new String[0]).normalize();
    private static final Path DOT = Paths.get(".", new String[0]);
    private static final Path DOT_DOT = Paths.get("..", new String[0]);
    private static final Logger logger = LoggerFactory.getLogger(LocalFileInputPlugin.class);

    public ConfigDiff transaction(ConfigSource config, FileInputPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createConfigMapper().map(config, PluginTask.class);
        List<String> files = LocalFileInputPlugin.listFiles(task);
        logger.info("Loading files {}", files);
        task.setFiles(files);
        int taskCount = task.getFiles().size();
        return this.resume(task.dump(), taskCount, control);
    }

    public ConfigDiff resume(TaskSource taskSource, int taskCount, FileInputPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createTaskMapper().map(taskSource, PluginTask.class);
        control.run(taskSource, taskCount);
        ConfigDiff configDiff = CONFIG_MAPPER_FACTORY.newConfigDiff();
        if (task.getFiles().isEmpty()) {
            if (task.getLastPath().isPresent()) {
                configDiff.set("last_path", (Object)task.getLastPath().get());
            }
        } else {
            ArrayList<String> files = new ArrayList<String>(task.getFiles());
            Collections.sort(files);
            configDiff.set("last_path", files.get(files.size() - 1));
        }
        return configDiff;
    }

    public void cleanup(TaskSource taskSource, int taskCount, List<TaskReport> successTaskReports) {
    }

    public TransactionalFileInput open(TaskSource taskSource, int taskIndex) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createTaskMapper().map(taskSource, PluginTask.class);
        final File file = new File(task.getFiles().get(taskIndex));
        return new InputStreamTransactionalFileInput(Exec.getBufferAllocator(), new InputStreamFileInput.Opener(){

            public InputStream open() throws IOException {
                return new FileInputStream(file);
            }
        }){

            public void abort() {
            }

            public TaskReport commit() {
                return CONFIG_MAPPER_FACTORY.newTaskReport();
            }

            public Optional<String> hintOfCurrentInputFileNameForLogging() {
                return Optional.ofNullable(file.getAbsolutePath());
            }
        };
    }

    static List<String> listFilesForTesting(PluginTask task) {
        return LocalFileInputPlugin.listFiles(task);
    }

    private static List<String> listFiles(PluginTask task) {
        String baseFileNamePrefix;
        Path dirToStartWalking;
        Path dirToMatch;
        Path pathPrefixResolved = WORKING_DIRECTORY.resolve(Paths.get(task.getPathPrefix(), new String[0]));
        if (Files.isDirectory(pathPrefixResolved, new LinkOption[0])) {
            dirToMatch = pathPrefixResolved;
            dirToStartWalking = LocalFileInputPlugin.getRealCasePathOfDirectoryNoFollowLinks(pathPrefixResolved);
            baseFileNamePrefix = "";
        } else {
            dirToMatch = Optional.ofNullable(pathPrefixResolved.getParent()).orElse(WORKING_DIRECTORY);
            dirToStartWalking = dirToMatch == WORKING_DIRECTORY ? WORKING_DIRECTORY : LocalFileInputPlugin.getRealCasePathOfDirectoryNoFollowLinks(dirToMatch);
            baseFileNamePrefix = pathPrefixResolved.getFileName().toString();
        }
        final PathMatcher baseFileNameMatcher = LocalFileInputPlugin.buildPathMatcherForBaseFileNamePrefix(baseFileNamePrefix);
        final PathMatcher dirNameMatcher = LocalFileInputPlugin.buildPathMatcherForDirectory(dirToMatch);
        final ArrayList filesFound = new ArrayList();
        final String lastPath = task.getLastPath().orElse(null);
        try {
            EnumSet<FileVisitOption> visitOptions;
            logger.info("Listing local files at directory '{}' filtering filename by prefix '{}'", (Object)(dirToMatch.equals(WORKING_DIRECTORY) ? "." : dirToMatch.toString()), (Object)baseFileNamePrefix);
            if (task.getFollowSymlinks()) {
                visitOptions = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            } else {
                visitOptions = EnumSet.noneOf(FileVisitOption.class);
                logger.info("\"follow_symlinks\" is set false. Note that symbolic links to directories are skipped.");
            }
            Files.walkFileTree(dirToStartWalking, visitOptions, Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dirOnVisit, BasicFileAttributes attrs) {
                    if (dirOnVisit.equals(dirToStartWalking)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (lastPath != null && dirOnVisit.toString().compareTo(lastPath) <= 0) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (!dirNameMatcher.matches(dirOnVisit)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    Path parent = Optional.ofNullable(dirOnVisit.getParent()).orElse(WORKING_DIRECTORY);
                    if (parent.equals(dirToStartWalking)) {
                        if (baseFileNameMatcher.matches(dirOnVisit.getFileName())) {
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path fileOnVisit, BasicFileAttributes attrs) {
                    try {
                        if (Files.isDirectory(fileOnVisit.toRealPath(new LinkOption[0]), new LinkOption[0])) {
                            return FileVisitResult.CONTINUE;
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Can't resolve symbolic link", ex);
                    }
                    if (lastPath != null && fileOnVisit.toString().compareTo(lastPath) <= 0) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!dirNameMatcher.matches(fileOnVisit)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path parent = Optional.ofNullable(fileOnVisit.getParent()).orElse(WORKING_DIRECTORY);
                    if (parent.equals(dirToStartWalking)) {
                        if (baseFileNameMatcher.matches(fileOnVisit.getFileName())) {
                            filesFound.add(fileOnVisit.toString());
                            return FileVisitResult.CONTINUE;
                        }
                    } else {
                        filesFound.add(fileOnVisit.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Failed get a list of local files at '%s'", dirToMatch), ex);
        }
        return Collections.unmodifiableList(filesFound);
    }

    private static StringBuilder buildGlobPatternStringBuilder(String pathString) {
        StringBuilder globPatternBuilder = new StringBuilder();
        pathString.chars().forEach(c -> {
            switch ((char)c) {
                case '*': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    globPatternBuilder.append('\\');
                    break;
                }
            }
            globPatternBuilder.append((char)c);
        });
        return globPatternBuilder;
    }

    private static PathMatcher buildPathMatcherForDirectory(Path dir) {
        String dirString = dir.toString();
        int dirLength = dirString.length();
        StringBuilder builder = LocalFileInputPlugin.buildGlobPatternStringBuilder(dirString);
        if (dirLength > 1 && builder.charAt(dirLength - 1) != File.separatorChar) {
            if (File.separatorChar == '\\') {
                builder.append('\\');
            }
            builder.append(File.separator);
        }
        return FileSystems.getDefault().getPathMatcher("glob:" + builder.toString() + "**");
    }

    private static PathMatcher buildPathMatcherForBaseFileNamePrefix(String baseFileNamePrefix) {
        StringBuilder builder = LocalFileInputPlugin.buildGlobPatternStringBuilder(baseFileNamePrefix);
        return FileSystems.getDefault().getPathMatcher("glob:" + builder.toString() + "*");
    }

    private static Path getRealCasePathOfDirectoryNoFollowLinks(Path dirNormalized) {
        Path built = dirNormalized.isAbsolute() ? dirNormalized.getRoot() : Paths.get("", new String[0]);
        for (Path pathElement : dirNormalized) {
            if (pathElement.equals(DOT_DOT)) {
                built = built.resolve(DOT_DOT);
                continue;
            }
            if (pathElement.equals(DOT)) {
                built = built.resolve(DOT);
                continue;
            }
            final Path startPath = built;
            final String pathElementString = pathElement.toString();
            final ArrayList found = new ArrayList();
            try {
                Files.walkFileTree(built, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        if (dir.equals(startPath)) {
                            return FileVisitResult.CONTINUE;
                        }
                        Path lastElement = dir.getFileName();
                        if (lastElement == null) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (pathElementString.equalsIgnoreCase(lastElement.toString())) {
                            found.add(dir);
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException ex) throws IOException {
                        if (pathElementString.equalsIgnoreCase(file.getFileName().toString())) {
                            throw ex;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                });
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            if (found.size() == 1) {
                built = (Path)found.get(0);
                continue;
            }
            if (found.size() > 1) {
                built = built.resolve(pathElement);
                continue;
            }
            throw new UncheckedIOException(new FileNotFoundException("Directory not found: \"" + built.resolve(pathElement).toString() + "\" for \"" + dirNormalized.toString() + "\""));
        }
        return built;
    }

    public static interface PluginTask
    extends Task {
        @Config(value="path_prefix")
        public String getPathPrefix();

        @Config(value="last_path")
        @ConfigDefault(value="null")
        public Optional<String> getLastPath();

        @Config(value="follow_symlinks")
        @ConfigDefault(value="false")
        public boolean getFollowSymlinks();

        public List<String> getFiles();

        public void setFiles(List<String> var1);
    }
}

