/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.guess.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigSource;
import org.embulk.spi.Buffer;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.Exec;
import org.embulk.spi.FileInput;
import org.embulk.spi.GuessPlugin;
import org.embulk.spi.json.JsonValue;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.file.FileInputInputStream;
import org.embulk.util.file.InputStreamFileInput;
import org.embulk.util.json.JsonParseException;
import org.embulk.util.json.JsonValueParser;

public class JsonGuessPlugin
implements GuessPlugin {
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();

    public ConfigDiff guess(ConfigSource config, Buffer sample) {
        ConfigDiff configDiff = CONFIG_MAPPER_FACTORY.newConfigDiff();
        if (!"json".equals(config.getNestedOrGetEmpty("parser").get(String.class, "type", (Object)"json"))) {
            return configDiff;
        }
        BufferAllocator bufferAllocator = Exec.getBufferAllocator();
        JsonValueParser parser = JsonGuessPlugin.newJsonParser(sample, bufferAllocator);
        boolean oneJsonParsed = false;
        try {
            JsonValue v = null;
            while ((v = parser.readJsonValue()) != null) {
                if (!v.isJsonObject()) {
                    throw new JsonParseException("v must be JSON object type");
                }
                oneJsonParsed = true;
            }
        }
        catch (JsonParseException v) {
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        if (oneJsonParsed) {
            ConfigDiff typeJson = CONFIG_MAPPER_FACTORY.newConfigDiff();
            typeJson.set("type", (Object)"json");
            configDiff.set("parser", (Object)typeJson);
        }
        return configDiff;
    }

    private static JsonValueParser newJsonParser(Buffer buffer, BufferAllocator bufferAllocator) {
        ArrayList<ByteArrayInputStream> inputStreams = new ArrayList<ByteArrayInputStream>();
        inputStreams.add(JsonGuessPlugin.buildByteArrayInputStream(buffer));
        InputStreamFileInput.IteratorProvider iteratorProvider = new InputStreamFileInput.IteratorProvider(inputStreams);
        FileInputInputStream input = new FileInputInputStream((FileInput)new InputStreamFileInput(bufferAllocator, (InputStreamFileInput.Provider)iteratorProvider));
        input.nextFile();
        try {
            return JsonValueParser.builder().build((InputStream)input);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static ByteArrayInputStream buildByteArrayInputStream(Buffer buffer) {
        return new ByteArrayInputStream(buffer.array());
    }
}

