/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.encoder.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskSource;
import org.embulk.spi.EncoderPlugin;
import org.embulk.spi.Exec;
import org.embulk.spi.FileOutput;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.embulk.util.file.FileOutputOutputStream;
import org.embulk.util.file.OutputStreamFileOutput;

public class GzipFileEncoderPlugin
implements EncoderPlugin {
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();

    public void transaction(ConfigSource config, EncoderPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createConfigMapper().map(config, PluginTask.class);
        if (1 > task.getLevel() || task.getLevel() > 9) {
            throw new ConfigException("\"level\" must be in the range of 1 <= level <= 9.");
        }
        control.run(task.dump());
    }

    public FileOutput open(TaskSource taskSource, final FileOutput fileOutput) {
        final PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createTaskMapper().map(taskSource, PluginTask.class);
        final FileOutputOutputStream output = new FileOutputOutputStream(fileOutput, Exec.getBufferAllocator(), FileOutputOutputStream.CloseMode.FLUSH);
        return new OutputStreamFileOutput(new OutputStreamFileOutput.Provider(){

            public OutputStream openNext() throws IOException {
                output.nextFile();
                return new GZIPOutputStream((OutputStream)output){
                    {
                        this.def.setLevel(task.getLevel());
                    }
                };
            }

            public void finish() throws IOException {
                fileOutput.finish();
            }

            public void close() throws IOException {
                fileOutput.close();
            }
        });
    }

    public static interface PluginTask
    extends Task {
        @Config(value="level")
        @ConfigDefault(value="6")
        public int getLevel();
    }
}

