/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.maven;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.supplier.RepositorySystemSupplier;
import org.embulk.deps.maven.MavenArtifactNotFoundException;
import org.embulk.deps.maven.MavenRepositoryNotFoundException;
import org.embulk.plugin.MavenPluginType;
import org.embulk.plugin.maven.MavenArtifactFinder;
import org.embulk.plugin.maven.MavenExcludeDependency;
import org.embulk.plugin.maven.MavenPluginPaths;

public class MavenArtifactFinderImpl
extends MavenArtifactFinder {
    private final Path givenLocalMavenRepositoryPath;
    private final Path absoluteLocalMavenRepositoryPath;
    private final RepositorySystemSupplier repositorySystemSupplier;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;

    public MavenArtifactFinderImpl(Path localMavenRepositoryPath) throws FileNotFoundException {
        Path absolutePath;
        try {
            absolutePath = localMavenRepositoryPath.normalize().toAbsolutePath();
        }
        catch (IOError ex) {
            throw new MavenRepositoryNotFoundException(localMavenRepositoryPath, (Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new MavenRepositoryNotFoundException(localMavenRepositoryPath, (Throwable)ex);
        }
        if (!Files.exists(absolutePath, new LinkOption[0])) {
            throw new MavenRepositoryNotFoundException(localMavenRepositoryPath, absolutePath, new NoSuchFileException(absolutePath.toString()));
        }
        if (!Files.isDirectory(absolutePath, new LinkOption[0])) {
            throw new MavenRepositoryNotFoundException(localMavenRepositoryPath, absolutePath, new NotDirectoryException(absolutePath.toString()));
        }
        this.givenLocalMavenRepositoryPath = localMavenRepositoryPath;
        this.absoluteLocalMavenRepositoryPath = absolutePath;
        this.repositorySystemSupplier = new RepositorySystemSupplier();
        this.repositorySystem = this.repositorySystemSupplier.get();
        this.repositorySystemSession = MavenArtifactFinderImpl.createRepositorySystemSession(this.repositorySystem, absolutePath);
    }

    public final MavenPluginPaths findMavenPluginJarsWithDirectDependencies(MavenPluginType pluginType, String category) throws FileNotFoundException {
        ArtifactDescriptorResult result;
        String groupId = pluginType.getGroup();
        String artifactId = pluginType.getArtifactId(category);
        String classifier = pluginType.getClassifier();
        String version = pluginType.getVersion();
        Set excludeDependencies = pluginType.getExcludeDependencies();
        Set includeDependencies = pluginType.getIncludeDependencies();
        try {
            result = this.describeMavenArtifact(groupId, artifactId, classifier, "jar", version);
        }
        catch (ArtifactDescriptorException ex) {
            throw new MavenArtifactNotFoundException(groupId, artifactId, classifier, version, this.givenLocalMavenRepositoryPath, this.absoluteLocalMavenRepositoryPath, ex);
        }
        ArrayList<Path> dependencyPaths = new ArrayList<Path>();
        for (Dependency dependency : result.getDependencies()) {
            Artifact artifact;
            String scope = dependency.getScope();
            if (!scope.equals("compile") && !scope.equals("runtime") || excludeDependencies.contains(MavenExcludeDependency.of((String)(artifact = dependency.getArtifact()).getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getClassifier()))) continue;
            Path dependencyPath = this.findMavenArtifact(artifact);
            dependencyPaths.add(dependencyPath);
        }
        for (Dependency dependency : includeDependencies) {
            DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), (String)dependency.getClassifier().orElse(null), "jar", dependency.getVersion());
            Path dependencyPath = this.findMavenArtifact((Artifact)artifact);
            dependencyPaths.add(dependencyPath);
        }
        Path artifactPath = this.findMavenArtifact(result.getArtifact());
        return MavenPluginPaths.of((MavenPluginType)pluginType, (Path)artifactPath, dependencyPaths);
    }

    private Path findMavenArtifact(Artifact artifact) throws MavenArtifactNotFoundException {
        ArtifactResult result;
        try {
            result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, new ArtifactRequest().setArtifact(artifact));
        }
        catch (ArtifactResolutionException ex) {
            throw new MavenArtifactNotFoundException(artifact, this.givenLocalMavenRepositoryPath, this.absoluteLocalMavenRepositoryPath, ex);
        }
        return result.getArtifact().getFile().toPath();
    }

    private ArtifactDescriptorResult describeMavenArtifact(String groupId, String artifactId, String classifier, String extension, String version) throws ArtifactDescriptorException {
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest().setArtifact((Artifact)new DefaultArtifact(groupId, artifactId, classifier, extension, version));
        return this.repositorySystem.readArtifactDescriptor(this.repositorySystemSession, descriptorRequest);
    }

    private static RepositorySystemSession createRepositorySystemSession(RepositorySystem repositorySystem, Path localRepositoryPath) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository repository = new LocalRepository(localRepositoryPath.toString());
        session.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, repository));
        return session;
    }
}

