/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.nio.charset.Charset;

public final class CharsetJacksonModule
extends SimpleModule {
    public CharsetJacksonModule() {
        this.addSerializer(Charset.class, new CharsetSerializer());
        this.addDeserializer(Charset.class, (JsonDeserializer)new CharsetDeserializer());
    }

    private static class CharsetDeserializer
    extends FromStringDeserializer<Charset> {
        public CharsetDeserializer() {
            super(Charset.class);
        }

        protected Charset _deserialize(String value, DeserializationContext context) throws JsonMappingException {
            try {
                return Charset.forName(value);
            }
            catch (UnsupportedOperationException ex) {
                throw new JsonMappingException(String.format("Unknown charset '%s'", value));
            }
        }
    }

    private static class CharsetSerializer
    extends JsonSerializer<Charset> {
        private CharsetSerializer() {
        }

        public void serialize(Charset value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.name());
        }
    }
}

