/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.cli;

import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.embulk.EmbulkVersion;
import org.embulk.cli.Command;
import org.embulk.deps.cli.CommandWriters;
import org.embulk.deps.cli.HelpFormatterWithPlaceholders;
import org.embulk.deps.cli.OptionsWithPlaceholders;
import org.embulk.deps.cli.PlaceholderOption;
import org.slf4j.Logger;

final class CommandLineImpl
extends org.embulk.cli.CommandLine {
    private static final int TERMINAL_WIDTH = 78;
    private static final String COMMANDS_HELP = "\nCommands:\n   run          Run a bulk load transaction.\n   cleanup      Cleanup resume state.\n   preview      Dry-run a bulk load transaction, and preview it.\n   guess        Guess missing parameters to complete configuration.\n   example      Create example files for a quick trial of Embulk.\n   license      Print out the license notice.\n   selfupdate   Upgrade Embulk to the specified version.\n   gem          Run \"gem\" to install a RubyGem plugin.\n   mkbundle     Create a new plugin bundle environment.\n   bundle       Update a plugin bundle environment.\n\n";
    static final Option RUBY = Option.builder((String)"R").hasArg().argName("OPTION").desc("Command-line option for JRuby. (Only '--dev')").build();
    static final Option LOG_LEVEL = Option.builder((String)"l").longOpt("log-level").hasArg().argName("LEVEL").desc("Set log level (error, warn, info, debug, trace)").build();
    static final Option LOG_PATH = Option.builder().longOpt("log-path").hasArg().argName("PATH").desc("Output log messages to a file (default: -)").build();
    static final Option PROPERTY = Option.builder((String)"X").hasArgs().numberOfArgs(2).valueSeparator('=').argName("KEY=VALUE").desc("Set Embulk system properties").build();
    static final Option HELP = Option.builder((String)"h").longOpt("help").desc("Print help").build();
    static final Option VERSION = Option.builder((String)"version").longOpt("version").desc("Show Embulk version").build();
    static final Option LOAD = Option.builder((String)"L").longOpt("load").hasArg().argName("PATH").desc("Add a local plugin path").build();
    static final Option LOAD_PATH = Option.builder((String)"I").longOpt("load-path").hasArg().argName("PATH").desc("Add Ruby script directory path ($LOAD_PATH)").build();
    static final Option CLASSPATH = Option.builder((String)"C").longOpt("classpath").hasArg().argName("PATH").desc("Add $CLASSPATH for JRuby separated by '" + File.pathSeparator + "'").build();
    static final Option BUNDLE = Option.builder((String)"b").longOpt("bundle").hasArg().argName("BUNDLE_DIR").desc("Path to a Gemfile directory").build();
    static final Option RESUME_STATE_RUN = Option.builder((String)"r").longOpt("resume-state").hasArg().argName("PATH").desc("Path to a file to write or read resume state").build();
    static final Option RESUME_STATE_CLEANUP = Option.builder((String)"r").longOpt("resume-state").hasArg().argName("PATH").desc("Path to a file to cleanup resume state").build();
    static final Option OUTPUT = Option.builder((String)"o").longOpt("output").hasArg().argName("PATH").desc("(deprecated)").build();
    static final Option OUTPUT_GUESS = Option.builder((String)"o").longOpt("output").hasArg().argName("PATH").desc("Path to a file to write the guessed configuration").build();
    static final Option CONFIG_DIFF = Option.builder((String)"c").longOpt("config-diff").hasArg().argName("PATH").desc("Path to a file of the next configuration diff").build();
    static final Option VERTICAL = Option.builder((String)"G").longOpt("vertical").desc("Use vertical output format").build();
    static final Option GUESS_PLUGINS = Option.builder((String)"g").longOpt("guess").hasArg().argName("NAMES").desc("Comma-separated list of guess plugin names").build();
    static final Option BUNDLE_PATH = Option.builder().longOpt("path").hasArg().argName("PATH").desc("Relative path from <directory> for the location to install gems to (e.g. --path shared/bundle).").build();
    static final Option FORCE_SELFUPDATE = Option.builder((String)"f").desc("Skip corruption check").build();
    private static final String COMMON_USAGE = "embulk [common options] <command> [command options]";
    private static final OptionsWithPlaceholders COMMON_OPTIONS = new OptionsWithPlaceholders().addOption(new PlaceholderOption("Common options:")).addOption(HELP).addOption(VERSION).addOption(LOG_LEVEL).addOption(LOG_PATH).addOption(PROPERTY).addOption(RUBY);
    private static final String BUNDLE_USAGE = "embulk [common options] bundle <arguments and options for bundle>";
    private static final String BUNDLE_HEADER = "\n\"embulk bundle\" runs Ruby's 'bundle' command in its background. Arguments are passed through to Ruby's 'bundle' command as-is. \"embulk bundle new\" is disabled, though.\n\nExamples:\n   $ embulk bundle       # Update bundled plugin installation.\n   $ embulk bundle new   # DOES NOT WORK!\n\n";
    private static final String GEM_USAGE = "embulk [common options] gem <arguments and options for gem>";
    private static final String GEM_HEADER = "\n\"embulk gem\" runs Ruby's 'gem' command in its background. Arguments are passed through to Ruby's 'gem' command as-is.\n\nExamples:\n   $ embulk gem install embulk-input-something   # Install a RubyGem plugin.\n   $ embulk gem list                             # List installed RubyGem plugins.\n   $ embulk gem help                             # Show help of Ruby's 'gem'.\n\n";
    private static final OptionsWithPlaceholders PLUGIN_OPTIONS = COMMON_OPTIONS.clone().addOption(new PlaceholderOption("")).addOption(new PlaceholderOption("Plugin options:")).addOption(LOAD).addOption(LOAD_PATH).addOption(CLASSPATH);
    private static final String RUN_USAGE = "embulk [common options] run [command options] <config.yml>";
    private static final OptionsWithPlaceholders RUN_OPTIONS = PLUGIN_OPTIONS.clone().addOption(BUNDLE).addOption(new PlaceholderOption("")).addOption(new PlaceholderOption("Other 'run' options:")).addOption(RESUME_STATE_RUN).addOption(OUTPUT).addOption(CONFIG_DIFF);
    private static final String RUN_HEADER = "\n\"embulk run\" runs a bulk load transaction.\n\n";
    private static final String CLEANUP_USAGE = "embulk [common options] cleanup [command options] <config.yml>";
    private static final OptionsWithPlaceholders CLEANUP_OPTIONS = PLUGIN_OPTIONS.clone().addOption(new PlaceholderOption("")).addOption(new PlaceholderOption("Another 'cleanup' option:")).addOption(RESUME_STATE_CLEANUP);
    private static final String CLEANUP_HEADER = "\n\"embulk cleanup\" cleans up resume state.\n\n";
    private static final String PREVIEW_USAGE = "embulk [common options] preview [command options] <config.yml>";
    private static final OptionsWithPlaceholders PREVIEW_OPTIONS = PLUGIN_OPTIONS.clone().addOption(new PlaceholderOption("")).addOption(new PlaceholderOption("Another 'preview' option:")).addOption(VERTICAL);
    private static final String PREVIEW_HEADER = "\n\"embulk preview\" dry-runs a bulk load transaction, and preview it.\n\n";
    private static final String GUESS_USAGE = "embulk [common options] guess [command options] <partial-config.yml>";
    private static final OptionsWithPlaceholders GUESS_OPTIONS = PLUGIN_OPTIONS.clone().addOption(new PlaceholderOption("")).addOption(new PlaceholderOption("Other 'guess' options:")).addOption(OUTPUT_GUESS).addOption(GUESS_PLUGINS);
    private static final String GUESS_HEADER = "\n\"embulk guess\" guesses missing parameters to complete configuration.\n\n";
    private static final String EXAMPLE_USAGE = "embulk [common options] example [command options] [directory]";
    private static final OptionsWithPlaceholders EXAMPLE_OPTIONS = COMMON_OPTIONS.clone();
    private static final String EXAMPLE_HEADER = "\n\"embulk example\" creates example files for a quick trial of Embulk.\n\n";
    private static final String LICENSE_USAGE = "embulk [common options] license";
    private static final OptionsWithPlaceholders LICENSE_OPTIONS = COMMON_OPTIONS.clone();
    private static final String LICENSE_HEADER = "\n\"embulk license\" prints the license notice.\n\n";
    private static final String MKBUNDLE_USAGE = "embulk [common options] mkbundle [command options] <directory>";
    private static final String MKBUNDLE_HEADER = "\n\"embulk mkbundle\" creates a new a \"bundle\" directory with Bundler and \"Gemfile\". You can install RubyGem plugins in the directory instead of Embulk home.\n\nSee/edit the generated <directory>/Gemfile to install RubyGem plugins in the bundle directory.  Use the \"-b\" or \"--bundle\" option to run with plugins in the bundle directory.\n\nExample:\n   $ embulk mkbundle ./dir       # Create a bundle directory.\n   $ cd dir                      # Go to the bundle directory.\n   (Edit Gemfile)                # Update the plugin list.\n   $ embulk bundle               # Update bundled plugin installation.\n   $ cd -                        # Go back to your previous directory.\n   $ embulk guess -b ./dir ...   # Guess with the bundled plugins.\n   $ embulk run   -b ./dir ...   # Run with bundled plugins.\n\n";
    private static final OptionsWithPlaceholders MKBUNDLE_OPTIONS = COMMON_OPTIONS.clone().addOption(new PlaceholderOption("")).addOption(new PlaceholderOption("Another 'mkbundle' option:")).addOption(BUNDLE_PATH);
    private static final String SELFUPDATE_USAGE = "embulk [common options] selfupdate [command options] <version>";
    private static final OptionsWithPlaceholders SELFUPDATE_OPTIONS = COMMON_OPTIONS.clone().addOption(new PlaceholderOption("")).addOption(new PlaceholderOption("Another 'selfupdate' option:")).addOption(FORCE_SELFUPDATE);
    private static final String SELFUPDATE_HEADER = "\n\"embulk selfupdate\" upgrades Embulk to the specified version.\n\n";
    private final boolean isValid;
    private final Command command;
    private final List<String> args;
    private final Properties commandLineProperties;
    private final String stdout;
    private final String stderr;

    private CommandLineImpl(boolean isValid, Command command, List<String> args, Properties commandLineProperties, String stdout, String stderr) {
        this.isValid = isValid;
        this.command = command;
        this.args = args;
        this.commandLineProperties = commandLineProperties;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    static CommandLineImpl of(List<String> originalArgs, Logger logger) {
        String commandString = CommandLineImpl.findCommandString(originalArgs);
        Command command = Command.of((String)commandString);
        switch (command) {
            case NONE: {
                return CommandLineImpl.ofNone(originalArgs, logger);
            }
            case UNKNOWN: {
                return CommandLineImpl.ofUnknown(originalArgs, commandString, logger);
            }
            case EXEC: 
            case IRB: 
            case MIGRATE: 
            case NEW: {
                return CommandLineImpl.ofUnsupported(command, commandString, logger);
            }
            case BUNDLE: {
                return CommandLineImpl.ofRubyCommand(command, commandString, originalArgs, BUNDLE_USAGE, BUNDLE_HEADER, logger);
            }
            case GEM: {
                return CommandLineImpl.ofRubyCommand(command, commandString, originalArgs, GEM_USAGE, GEM_HEADER, logger);
            }
            case RUN: {
                return CommandLineImpl.ofCommand(command, originalArgs, 1, 1, RUN_OPTIONS, RUN_USAGE, RUN_HEADER, logger);
            }
            case CLEANUP: {
                return CommandLineImpl.ofCommand(command, originalArgs, 1, 1, CLEANUP_OPTIONS, CLEANUP_USAGE, CLEANUP_HEADER, logger);
            }
            case PREVIEW: {
                return CommandLineImpl.ofCommand(command, originalArgs, 1, 1, PREVIEW_OPTIONS, PREVIEW_USAGE, PREVIEW_HEADER, logger);
            }
            case GUESS: {
                return CommandLineImpl.ofCommand(command, originalArgs, 1, 1, GUESS_OPTIONS, GUESS_USAGE, GUESS_HEADER, logger);
            }
            case EXAMPLE: {
                return CommandLineImpl.ofCommand(command, originalArgs, 0, 1, EXAMPLE_OPTIONS, EXAMPLE_USAGE, EXAMPLE_HEADER, logger);
            }
            case LICENSE: {
                return CommandLineImpl.ofCommand(command, originalArgs, 0, 0, LICENSE_OPTIONS, LICENSE_USAGE, LICENSE_HEADER, logger);
            }
            case MKBUNDLE: {
                return CommandLineImpl.ofCommand(command, originalArgs, 1, 1, MKBUNDLE_OPTIONS, MKBUNDLE_USAGE, MKBUNDLE_HEADER, logger);
            }
            case SELFUPDATE: {
                return CommandLineImpl.ofCommand(command, originalArgs, 1, 1, SELFUPDATE_OPTIONS, SELFUPDATE_USAGE, SELFUPDATE_HEADER, logger);
            }
        }
        throw new IllegalStateException("'" + commandString + "' is recognized, but unexpectedly unknown.");
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final Command getCommand() {
        return this.command;
    }

    public final List<String> getArguments() {
        return this.args;
    }

    public final Properties getCommandLineProperties() {
        Properties copied = new Properties();
        for (String key : this.commandLineProperties.stringPropertyNames()) {
            copied.setProperty(key, this.commandLineProperties.getProperty(key));
        }
        return copied;
    }

    public final String getStdOut() {
        return this.stdout;
    }

    public final String getStdErr() {
        return this.stderr;
    }

    private static CommandLineImpl ofValid(Command command, String[] args, Properties commandLineProperties, CommandWriters writers) {
        List<String> argsList = Arrays.asList(args);
        return new CommandLineImpl(true, command, argsList.subList(1, argsList.size()), commandLineProperties, writers.getStdOut(), writers.getStdErr());
    }

    private static CommandLineImpl ofInvalid(Command command, CommandWriters writers) {
        return new CommandLineImpl(false, command, Collections.unmodifiableList(new ArrayList()), new Properties(), writers.getStdOut(), writers.getStdErr());
    }

    private static CommandLineImpl ofNone(List<String> originalArgs, Logger logger) {
        CommandWriters writers = new CommandWriters();
        CommandLine commandLine = CommandLineImpl.parse(originalArgs, COMMON_OPTIONS, COMMON_USAGE, COMMANDS_HELP, writers, logger);
        if (commandLine == null) {
            return CommandLineImpl.ofInvalid(Command.NONE, writers);
        }
        if (commandLine.hasOption(VERSION.getOpt())) {
            writers.printlnOut("Embulk " + EmbulkVersion.VERSION);
            return CommandLineImpl.ofInvalid(Command.NONE, writers);
        }
        CommandLineImpl.printHelp(COMMON_OPTIONS, COMMON_USAGE, COMMANDS_HELP, writers.getStdOutWriter());
        return CommandLineImpl.ofInvalid(Command.NONE, writers);
    }

    private static CommandLineImpl ofUnknown(List<String> originalArgs, String commandString, Logger logger) {
        CommandWriters writers = new CommandWriters();
        writers.getStdErrWriter().println("embulk: '" + commandString + "' is not an embulk command.");
        CommandLine commandLine = CommandLineImpl.parse(originalArgs, COMMON_OPTIONS, COMMON_USAGE, COMMANDS_HELP, writers, logger);
        if (commandLine == null) {
            return CommandLineImpl.ofInvalid(Command.UNKNOWN, writers);
        }
        CommandLineImpl.printHelp(COMMON_OPTIONS, COMMON_USAGE, COMMANDS_HELP, writers.getStdOutWriter());
        return CommandLineImpl.ofInvalid(Command.UNKNOWN, writers);
    }

    private static CommandLineImpl ofUnsupported(Command command, String commandString, Logger logger) {
        CommandWriters writers = new CommandWriters();
        writers.getStdErrWriter().println("embulk: '" + commandString + "' is no longer available.");
        CommandLineImpl.printHelp(COMMON_OPTIONS, COMMON_USAGE, COMMANDS_HELP, writers.getStdOutWriter());
        return CommandLineImpl.ofInvalid(command, writers);
    }

    private static CommandLineImpl ofCommand(Command command, List<String> originalArgs, int minArgs, int maxArgs, Options options, String usage, String header, Logger logger) {
        CommandWriters writers = new CommandWriters();
        CommandLine commandLine = CommandLineImpl.parse(originalArgs, options, usage, header, writers, logger);
        if (commandLine == null) {
            return CommandLineImpl.ofInvalid(command, writers);
        }
        if (commandLine.hasOption(HELP.getOpt())) {
            CommandLineImpl.printHelp(options, usage, header, writers.getStdOutWriter());
            return CommandLineImpl.ofInvalid(command, writers);
        }
        String[] args = commandLine.getArgs();
        if (minArgs > args.length - 1 || args.length - 1 > maxArgs) {
            if (minArgs == maxArgs) {
                writers.printlnErr("embulk: '" + command.toString() + "' needs exact " + minArgs + " argument(s).");
            } else {
                writers.printlnErr("embulk: '" + command.toString() + "' needs " + minArgs + " - " + maxArgs + " argument(s).");
            }
            CommandLineImpl.printHelp(options, usage, header, writers.getStdOutWriter());
            return CommandLineImpl.ofInvalid(command, writers);
        }
        Properties properties = new Properties();
        for (Option option : commandLine.getOptions()) {
            CommandLineImpl.processOptionToProperties(option, command, properties, logger);
        }
        return CommandLineImpl.ofValid(command, args, properties, writers);
    }

    private static CommandLineImpl ofRubyCommand(Command command, String commandString, List<String> originalArgs, String usage, String header, Logger logger) {
        int index = originalArgs.indexOf(commandString);
        if (index < 0) {
            throw new IllegalStateException("Internal error: '" + commandString + "' is unexpectedly not found.");
        }
        CommandWriters writers = new CommandWriters();
        CommandLine commandLine = CommandLineImpl.parse(originalArgs.subList(0, index + 1), COMMON_OPTIONS, usage, header, writers, logger);
        if (commandLine == null) {
            return CommandLineImpl.ofInvalid(command, writers);
        }
        if (commandLine.hasOption(HELP.getOpt())) {
            CommandLineImpl.printHelp(COMMON_OPTIONS, usage, header, writers.getStdOutWriter());
            return CommandLineImpl.ofInvalid(command, writers);
        }
        String[] args = commandLine.getArgs();
        if (args.length != 1) {
            throw new IllegalStateException("Internal error: Arguments after '" + commandString + "' are unexpectedly processed.");
        }
        Properties properties = new Properties();
        for (Option option : commandLine.getOptions()) {
            CommandLineImpl.processOptionToProperties(option, command, properties, logger);
        }
        return new CommandLineImpl(true, command, originalArgs.subList(index + 1, originalArgs.size()), properties, writers.getStdOut(), writers.getStdErr());
    }

    private static CommandLine parse(List<String> originalArgs, Options options, String usage, String header, CommandWriters writers, Logger logger) {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine commandLine = parser.parse(options, originalArgs.toArray(new String[0]), false);
            if (commandLine.hasOption(RUBY.getOpt())) {
                logger.warn("The command line option \"-R\" is deprecated. Set an Embulk system property \"jruby_command_line_options\" instead. \"-X jruby_command_line_options=--dev\", for example.");
            }
            return commandLine;
        }
        catch (ParseException ex) {
            writers.printlnErr("embulk: " + ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            CommandLineImpl.printHelp(options, usage, header, writers.getStdOutWriter());
            return null;
        }
    }

    private static void printHelp(Options options, String usage, String header, PrintWriter writer) {
        HelpFormatterWithPlaceholders formatter = new HelpFormatterWithPlaceholders("Usage: ", 22);
        formatter.printHelp(writer, 78, usage, header, options, 3, 5, "", false);
        writer.flush();
    }

    private static String findCommandString(List<String> originalArgs) {
        CommandLine commandLine;
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse((Options)COMMON_OPTIONS, originalArgs.toArray(new String[0]), true);
        }
        catch (ParseException ex) {
            return null;
        }
        for (String arg : commandLine.getArgs()) {
            if (arg.startsWith("-")) continue;
            return arg;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processOptionToProperties(Option option, Command command, Properties properties, Logger logger) {
        if (LOG_LEVEL.getOpt().equals(option.getOpt())) {
            properties.setProperty("log_level", option.getValue());
            return;
        } else if (LOG_PATH.getLongOpt().equals(option.getLongOpt())) {
            properties.setProperty("log_path", option.getValue());
            return;
        } else if (PROPERTY.getOpt().equals(option.getOpt())) {
            String[] values = option.getValues();
            if (values.length == 1) {
                properties.setProperty(values[0], "");
                return;
            } else {
                if (values.length != 2) throw new IllegalStateException("'-X' expects key=value, but it unexpectedly had more.");
                properties.setProperty(values[0], values[1]);
            }
            return;
        } else if (RUBY.getOpt().equals(option.getOpt())) {
            String oldValue = properties.getProperty("jruby_command_line_options");
            String newValue = option.getValue();
            if (oldValue == null || oldValue.isEmpty()) {
                properties.setProperty("jruby_command_line_options", newValue);
                return;
            } else {
                properties.setProperty("jruby_command_line_options", oldValue + "," + newValue);
            }
            return;
        } else if (LOAD.getOpt().equals(option.getOpt())) {
            String oldValue = properties.getProperty("jruby_load_path");
            String newValue = Paths.get(option.getValue(), new String[0]).resolve("lib").toString();
            if (oldValue == null || oldValue.isEmpty()) {
                properties.setProperty("jruby_load_path", newValue);
                return;
            } else {
                properties.setProperty("jruby_load_path", oldValue + File.pathSeparator + newValue);
            }
            return;
        } else if (LOAD_PATH.getOpt().equals(option.getOpt())) {
            String oldValue = properties.getProperty("jruby_load_path");
            String newValue = option.getValue();
            if (oldValue == null || oldValue.isEmpty()) {
                properties.setProperty("jruby_load_path", newValue);
                return;
            } else {
                properties.setProperty("jruby_load_path", oldValue + File.pathSeparator + newValue);
            }
            return;
        } else if (CLASSPATH.getOpt().equals(option.getOpt())) {
            properties.setProperty("jruby_classpath", option.getValue());
            return;
        } else if (BUNDLE.getOpt().equals(option.getOpt())) {
            properties.setProperty("jruby_global_bundler_plugin_source_directory", option.getValue());
            return;
        } else if (RESUME_STATE_RUN.getOpt().equals(option.getOpt()) || RESUME_STATE_CLEANUP.getOpt().equals(option.getOpt())) {
            properties.setProperty("resume_state_path", option.getValue());
            return;
        } else if (VERTICAL.getOpt().equals(option.getOpt())) {
            properties.setProperty("preview_format", "vertical");
            return;
        } else if (OUTPUT.getOpt().equals(option.getOpt()) || OUTPUT_GUESS.getOpt().equals(option.getOpt())) {
            properties.setProperty("output_path", option.getValue());
            if (command != Command.RUN) return;
            logger.warn("Run with -o option is deprecated. Please use -c option instead. For example,\n\n$ embulk run config.yml -c diff.yml\n\nThis -c option stores only diff of the next configuration. The diff will be merged to the original config.yml file.");
            return;
        } else if (GUESS_PLUGINS.getOpt().equals(option.getOpt())) {
            properties.setProperty("guess_plugins", option.getValue());
            return;
        } else if (FORCE_SELFUPDATE.getOpt().equals(option.getOpt())) {
            properties.setProperty("force_selfupdate", "true");
            return;
        } else if (BUNDLE_PATH.getLongOpt().equals(option.getLongOpt())) {
            properties.setProperty("bundle_path", option.getValue());
            return;
        } else {
            if (!CONFIG_DIFF.getOpt().equals(option.getOpt())) return;
            properties.setProperty("config_diff_path", option.getValue());
        }
    }
}

