/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.config.DataSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.deps.config.ModelManagerDelegateImpl;

public class DataSourceImpl
implements ConfigSource,
TaskSource,
TaskReport,
ConfigDiff {
    protected final ObjectNode data;
    protected final ModelManagerDelegateImpl model;

    public DataSourceImpl(ModelManagerDelegateImpl model) {
        this(model, new ObjectNode(JsonNodeFactory.instance));
    }

    public DataSourceImpl(ModelManagerDelegateImpl model, ObjectNode data) {
        this.data = data;
        this.model = model;
    }

    protected DataSourceImpl newInstance(ModelManagerDelegateImpl model, ObjectNode data) {
        return new DataSourceImpl(model, data);
    }

    @Deprecated
    public ObjectNode getObjectNode() {
        return this.data;
    }

    public List<String> getAttributeNames() {
        ArrayList copy = new ArrayList();
        this.data.fieldNames().forEachRemaining(copy::add);
        return Collections.unmodifiableList(copy);
    }

    @Deprecated
    public Iterable<Map.Entry<String, JsonNode>> getAttributes() {
        return new Iterable<Map.Entry<String, JsonNode>>(){

            @Override
            public Iterator<Map.Entry<String, JsonNode>> iterator() {
                return DataSourceImpl.this.data.fields();
            }
        };
    }

    public boolean isEmpty() {
        return !this.data.fieldNames().hasNext();
    }

    public boolean has(String attrName) {
        return this.data.has(attrName);
    }

    public boolean hasList(String attrName) {
        if (!this.data.has(attrName)) {
            return false;
        }
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            return false;
        }
        return json.isArray();
    }

    public boolean hasNested(String attrName) {
        if (!this.data.has(attrName)) {
            return false;
        }
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            return false;
        }
        return json.isObject();
    }

    public <E> E get(Class<E> type, String attrName) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            throw new ConfigException("Attribute " + attrName + " is required but not set");
        }
        return this.model.readObject(type, json.traverse());
    }

    public <E> E get(Class<E> type, String attrName, E defaultValue) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            return defaultValue;
        }
        return this.model.readObject(type, json.traverse());
    }

    public <E> List<E> getListOf(Class<E> type, String attrName) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            return Collections.emptyList();
        }
        if (!json.isArray()) {
            throw new ConfigException("Attribute " + attrName + " must be an array");
        }
        ArrayList<E> list = new ArrayList<E>();
        for (JsonNode element : () -> json.elements()) {
            list.add(this.model.readObject(type, element.traverse()));
        }
        return Collections.unmodifiableList(list);
    }

    public DataSourceImpl getNested(String attrName) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            throw new ConfigException("Attribute " + attrName + " is required but not set");
        }
        if (!json.isObject()) {
            throw new ConfigException("Attribute " + attrName + " must be an object");
        }
        return this.newInstance(this.model, (ObjectNode)json);
    }

    public DataSourceImpl getNestedOrSetEmpty(String attrName) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            json = this.data.objectNode();
            this.data.set(attrName, json);
        } else if (!json.isObject()) {
            throw new ConfigException("Attribute " + attrName + " must be an object");
        }
        return this.newInstance(this.model, (ObjectNode)json);
    }

    public DataSourceImpl getNestedOrGetEmpty(String attrName) {
        JsonNode json = this.data.get(attrName);
        if (json == null) {
            json = this.data.objectNode();
        } else if (!json.isObject()) {
            throw new ConfigException("Attribute " + attrName + " must be an object");
        }
        return this.newInstance(this.model, (ObjectNode)json);
    }

    public DataSourceImpl set(String attrName, Object v) {
        if (v == null) {
            this.remove(attrName);
        } else {
            this.data.set(attrName, this.model.writeObjectAsJsonNode(v));
        }
        return this;
    }

    public DataSourceImpl setNested(String attrName, DataSource v) {
        if (v == null) {
            this.data.set(attrName, null);
        } else {
            String vJsonStringified = v.toJson();
            if (vJsonStringified == null) {
                throw new ConfigException((Throwable)new NullPointerException("DataSource#setNested accepts only valid DataSource"));
            }
            JsonNode vJsonNode = this.model.readObject(JsonNode.class, vJsonStringified);
            if (!vJsonNode.isObject()) {
                throw new ConfigException((Throwable)new ClassCastException("DataSource#setNested accepts only valid JSON object"));
            }
            this.data.set(attrName, (JsonNode)((ObjectNode)vJsonNode));
        }
        return this;
    }

    public DataSourceImpl setAll(DataSource other) {
        if (other == null) {
            throw new ConfigException((Throwable)new NullPointerException("DataSource#setAll accepts only non-null value"));
        }
        String otherJsonStringified = other.toJson();
        if (otherJsonStringified == null) {
            throw new ConfigException((Throwable)new NullPointerException("DataSource#setAll accepts only valid DataSource"));
        }
        JsonNode otherJsonNode = this.model.readObject(JsonNode.class, otherJsonStringified);
        if (!otherJsonNode.isObject()) {
            throw new ConfigException((Throwable)new ClassCastException("DataSource#setAll accepts only valid JSON object"));
        }
        ObjectNode otherObjectNode = (ObjectNode)otherJsonNode;
        for (Map.Entry field : () -> otherObjectNode.fields()) {
            this.data.set((String)field.getKey(), (JsonNode)field.getValue());
        }
        return this;
    }

    public DataSourceImpl remove(String attrName) {
        this.data.remove(attrName);
        return this;
    }

    public DataSourceImpl deepCopy() {
        return this.newInstance(this.model, this.data.deepCopy());
    }

    public DataSourceImpl merge(DataSource other) {
        if (other == null) {
            throw new ConfigException((Throwable)new NullPointerException("DataSource#merge accepts only non-null value"));
        }
        String otherJsonStringified = other.toJson();
        if (otherJsonStringified == null) {
            throw new ConfigException((Throwable)new NullPointerException("DataSource#merge accepts only valid DataSource"));
        }
        JsonNode otherJsonNode = this.model.readObject(JsonNode.class, otherJsonStringified);
        if (!otherJsonNode.isObject()) {
            throw new ConfigException((Throwable)new ClassCastException("DataSource#setAll accepts only valid JSON object"));
        }
        DataSourceImpl.mergeJsonObject(this.data, (ObjectNode)otherJsonNode);
        return this;
    }

    public String toJson() {
        return this.model.writeObject(this.data);
    }

    public Map<String, Object> toMap() {
        return DataSourceImpl.jsonObjectToMap(this.data);
    }

    private static void mergeJsonObject(ObjectNode src, ObjectNode other) {
        Iterator ite = other.fields();
        while (ite.hasNext()) {
            Map.Entry pair = (Map.Entry)ite.next();
            JsonNode s = src.get((String)pair.getKey());
            JsonNode v = (JsonNode)pair.getValue();
            if (v.isObject() && s != null && s.isObject()) {
                DataSourceImpl.mergeJsonObject((ObjectNode)s, (ObjectNode)v);
                continue;
            }
            if (v.isArray() && s != null && s.isArray()) {
                DataSourceImpl.mergeJsonArray((ArrayNode)s, (ArrayNode)v);
                continue;
            }
            src.replace((String)pair.getKey(), v);
        }
    }

    private static void mergeJsonArray(ArrayNode src, ArrayNode other) {
        for (int i = 0; i < other.size(); ++i) {
            JsonNode s = src.get(i);
            JsonNode v = other.get(i);
            if (s == null) {
                src.add(v);
                continue;
            }
            if (v.isObject() && s.isObject()) {
                DataSourceImpl.mergeJsonObject((ObjectNode)s, (ObjectNode)v);
                continue;
            }
            if (v.isArray() && s.isArray()) {
                DataSourceImpl.mergeJsonArray((ArrayNode)s, (ArrayNode)v);
                continue;
            }
            src.remove(i);
            src.insert(i, v);
        }
    }

    private static Map<String, Object> jsonObjectToMap(ObjectNode object) {
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry field : () -> object.fields()) {
            map.put(field.getKey(), DataSourceImpl.jsonToPlain((JsonNode)field.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    private static List<Object> jsonArrayToList(ArrayNode array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonNode element : () -> array.elements()) {
            list.add(DataSourceImpl.jsonToPlain(element));
        }
        return Collections.unmodifiableList(list);
    }

    private static Object jsonToPlain(JsonNode json) {
        if (json == null || json.isNull()) {
            return null;
        }
        if (json.isBoolean()) {
            return json.booleanValue();
        }
        if (json.isInt()) {
            return json.intValue();
        }
        if (json.isLong()) {
            return json.longValue();
        }
        if (json.isDouble()) {
            return json.doubleValue();
        }
        if (json.isTextual()) {
            return json.textValue();
        }
        if (json.isArray()) {
            return DataSourceImpl.jsonArrayToList((ArrayNode)json);
        }
        if (json.isObject()) {
            return DataSourceImpl.jsonObjectToMap((ObjectNode)json);
        }
        throw new ConfigException("Unexpected JSON node type: " + json.getNodeType().toString());
    }

    @Deprecated
    public <T> T loadTask(Class<T> taskType) {
        return this.model.readObject(taskType, this.data.traverse());
    }

    @Deprecated
    public <T> T loadConfig(Class<T> taskType) {
        return this.model.readObjectWithConfigSerDe(taskType, this.data.traverse());
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof DataSource)) {
            return false;
        }
        DataSource otherDataSource = (DataSource)other;
        String otherJsonStringified = otherDataSource.toJson();
        if (otherJsonStringified == null) {
            return false;
        }
        JsonNode otherJsonNode = this.model.readObject(JsonNode.class, otherJsonStringified);
        if (!otherJsonNode.isObject()) {
            return false;
        }
        return this.data.equals((Object)((ObjectNode)otherJsonNode));
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

