/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.decoder.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskSource;
import org.embulk.spi.DecoderPlugin;
import org.embulk.spi.Exec;
import org.embulk.spi.FileInput;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.embulk.util.file.FileInputInputStream;
import org.embulk.util.file.InputStreamFileInput;

public class GzipFileDecoderPlugin
implements DecoderPlugin {
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();

    public void transaction(ConfigSource config, DecoderPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createConfigMapper().map(config, PluginTask.class);
        control.run(task.dump());
    }

    public FileInput open(TaskSource taskSource, final FileInput fileInput) {
        final FileInputInputStream files = new FileInputInputStream(fileInput);
        return new InputStreamFileInput(Exec.getBufferAllocator(), new InputStreamFileInput.Provider(){

            public InputStreamFileInput.InputStreamWithHints openNextWithHints() throws IOException {
                if (!files.nextFile()) {
                    return null;
                }
                return new InputStreamFileInput.InputStreamWithHints((InputStream)new GZIPInputStream((InputStream)files, 8192), (String)fileInput.hintOfCurrentInputFileNameForLogging().orElse(null));
            }

            public void close() throws IOException {
                files.close();
            }
        });
    }

    public static interface PluginTask
    extends Task {
    }
}

