/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.decoder.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskSource;
import org.embulk.spi.DecoderPlugin;
import org.embulk.spi.Exec;
import org.embulk.spi.FileInput;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.embulk.util.file.FileInputInputStream;
import org.embulk.util.file.InputStreamFileInput;

public class Bzip2FileDecoderPlugin
implements DecoderPlugin {
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();

    public void transaction(ConfigSource config, DecoderPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createConfigMapper().map(config, PluginTask.class);
        control.run(task.dump());
    }

    public FileInput open(TaskSource taskSource, final FileInput fileInput) {
        final FileInputInputStream files = new FileInputInputStream(fileInput);
        return new InputStreamFileInput(Exec.getBufferAllocator(), new InputStreamFileInput.Provider(){

            public InputStreamFileInput.InputStreamWithHints openNextWithHints() throws IOException {
                if (!files.nextFile()) {
                    return null;
                }
                return new InputStreamFileInput.InputStreamWithHints((InputStream)new BZip2CompressorInputStream((InputStream)files, true), (String)fileInput.hintOfCurrentInputFileNameForLogging().orElse(null));
            }

            public void close() throws IOException {
                files.close();
            }
        });
    }

    public static interface PluginTask
    extends Task {
    }
}

