/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.Column;
import org.embulk.spi.PageOutput;
import org.embulk.spi.Schema;
import org.embulk.spi.time.Timestamp;
import org.msgpack.value.Value;

public class PageBuilder
implements AutoCloseable {
    private static final ClassLoader CLASS_LOADER = PageBuilder.class.getClassLoader();
    private final PageBuilder delegate;

    PageBuilder() {
        this.delegate = null;
    }

    private PageBuilder(PageBuilder delegate) {
        this.delegate = delegate;
    }

    @Deprecated
    public PageBuilder(BufferAllocator allocator, Schema schema, PageOutput output) {
        this(PageBuilder.createImplInstance(allocator, schema, output));
    }

    public Schema getSchema() {
        return this.delegate.getSchema();
    }

    public void setNull(Column column) {
        this.delegate.setNull(column);
    }

    public void setNull(int columnIndex) {
        this.delegate.setNull(columnIndex);
    }

    public void setBoolean(Column column, boolean value) {
        this.delegate.setBoolean(column, value);
    }

    public void setBoolean(int columnIndex, boolean value) {
        this.delegate.setBoolean(columnIndex, value);
    }

    public void setLong(Column column, long value) {
        this.delegate.setLong(column, value);
    }

    public void setLong(int columnIndex, long value) {
        this.delegate.setLong(columnIndex, value);
    }

    public void setDouble(Column column, double value) {
        this.delegate.setDouble(column, value);
    }

    public void setDouble(int columnIndex, double value) {
        this.delegate.setDouble(columnIndex, value);
    }

    public void setString(Column column, String value) {
        this.delegate.setString(column, value);
    }

    public void setString(int columnIndex, String value) {
        this.delegate.setString(columnIndex, value);
    }

    public void setJson(Column column, Value value) {
        this.delegate.setJson(column, value);
    }

    public void setJson(int columnIndex, Value value) {
        this.delegate.setJson(columnIndex, value);
    }

    @Deprecated
    public void setTimestamp(Column column, Timestamp value) {
        this.delegate.setTimestamp(column, value);
    }

    public void setTimestamp(Column column, Instant value) {
        this.delegate.setTimestamp(column, value);
    }

    @Deprecated
    public void setTimestamp(int columnIndex, Timestamp value) {
        this.delegate.setTimestamp(columnIndex, value);
    }

    public void setTimestamp(int columnIndex, Instant value) {
        this.delegate.setTimestamp(columnIndex, value);
    }

    public void addRecord() {
        this.delegate.addRecord();
    }

    public void flush() {
        this.delegate.flush();
    }

    public void finish() {
        this.delegate.finish();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private static PageBuilder createImplInstance(BufferAllocator allocator, Schema schema, PageOutput output) {
        try {
            return (PageBuilder)Holder.CONSTRUCTOR.newInstance(allocator, schema, output);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
            throw new LinkageError("[FATAL] org.embulk.spi.PageBuilderImpl is invalid.", ex);
        }
        catch (InvocationTargetException ex) {
            PageBuilder.throwCheckedForcibly(ex.getTargetException());
            return null;
        }
    }

    private static Class<PageBuilder> loadPageBuilderImpl() throws ClassNotFoundException {
        return CLASS_LOADER.loadClass("org.embulk.spi.PageBuilderImpl");
    }

    private static void throwCheckedForcibly(Throwable ex) {
        PageBuilder.throwCheckedForciblyInternal(ex);
    }

    private static <E extends Throwable> void throwCheckedForciblyInternal(Throwable ex) throws E {
        throw ex;
    }

    private static class Holder {
        private static final Class<PageBuilder> IMPL_CLASS;
        private static final Constructor<PageBuilder> CONSTRUCTOR;

        private Holder() {
        }

        static {
            try {
                IMPL_CLASS = PageBuilder.loadPageBuilderImpl();
            }
            catch (ClassNotFoundException ex) {
                throw new LinkageError("[FATAL] org.embulk.spi.PageBuilderImpl is not found.", ex);
            }
            try {
                CONSTRUCTOR = IMPL_CLASS.getConstructor(BufferAllocator.class, Schema.class, PageOutput.class);
            }
            catch (NoSuchMethodException ex) {
                throw new LinkageError("[FATAL] org.embulk.spi.PageBuilderImpl does not have an expected constructor.", ex);
            }
        }
    }
}

