/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class Timestamp
implements Comparable<Timestamp> {
    private static final Pattern INSTANT_PATTERN = Pattern.compile("(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})(?:\\.(\\d{1,9}))? (?:UTC|\\+?00\\:?00)");
    private static final DateTimeFormatter INSTANT_FORMATTER_SECONDS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter INSTANT_FORMATTER_MILLISECONDS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneOffset.UTC);
    private final Instant instant;

    private Timestamp(Instant instant) {
        this.instant = instant;
    }

    public static Timestamp ofString(String string) {
        return new Timestamp(Timestamp.parseInstant(string));
    }

    public static Timestamp ofInstant(Instant instant) {
        return new Timestamp(instant);
    }

    public static Timestamp ofEpochSecond(long epochSecond) {
        return new Timestamp(Instant.ofEpochSecond(epochSecond));
    }

    public static Timestamp ofEpochSecond(long epochSecond, long nanoAdjustment) {
        return new Timestamp(Instant.ofEpochSecond(epochSecond, nanoAdjustment));
    }

    public static Timestamp ofEpochMilli(long epochMilli) {
        return new Timestamp(Instant.ofEpochMilli(epochMilli));
    }

    public Instant getInstant() {
        return this.instant;
    }

    public long getEpochSecond() {
        return this.instant.getEpochSecond();
    }

    public int getNano() {
        return this.instant.getNano();
    }

    public long toEpochMilli() {
        return this.instant.toEpochMilli();
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Timestamp)) {
            return false;
        }
        Timestamp other = (Timestamp)otherObject;
        return this.instant.equals(other.instant);
    }

    public int hashCode() {
        return this.instant.hashCode() ^ 0x55555555;
    }

    @Override
    public int compareTo(Timestamp other) {
        return this.instant.compareTo(other.instant);
    }

    public String toString() {
        return Timestamp.toString(this.instant);
    }

    private static String toString(Instant instant) {
        int zeroDigits;
        String digits;
        if (instant == null) {
            throw new NullPointerException("Timestamp owns a null Instant.");
        }
        int nano = instant.getNano();
        if (nano == 0) {
            return INSTANT_FORMATTER_SECONDS.format(instant) + " UTC";
        }
        if (nano % 1000000 == 0) {
            return INSTANT_FORMATTER_MILLISECONDS.format(instant) + " UTC";
        }
        StringBuilder builder = new StringBuilder();
        INSTANT_FORMATTER_SECONDS.formatTo(instant, builder);
        builder.append(".");
        if (nano % 1000 == 0) {
            digits = Integer.toString(nano / 1000);
            zeroDigits = 6 - digits.length();
        } else {
            digits = Integer.toString(nano);
            zeroDigits = 9 - digits.length();
        }
        builder.append(digits);
        for (int i = 0; i < zeroDigits; ++i) {
            builder.append('0');
        }
        builder.append(" UTC");
        return builder.toString();
    }

    private static Instant parseInstant(String string) {
        int nanoAdjustment;
        String fractional;
        long epochSecond;
        String integral;
        if (string == null) {
            throw new NullPointerException("Timestamp#ofString receives only a non-null String.");
        }
        Matcher matcher = INSTANT_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new NumberFormatException("Timestamp#ofString received an invalid format: '" + string + "'");
        }
        try {
            integral = matcher.group(1);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unexpected error in retrieving the integral part of: '" + string + "'", ex);
        }
        try {
            epochSecond = LocalDateTime.parse(integral, INSTANT_FORMATTER_SECONDS).toEpochSecond(ZoneOffset.UTC);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unexpected error in parsing: '" + integral + "'", ex);
        }
        try {
            fractional = matcher.group(2);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unexpected error in retrieving the fractional part of: '" + string + "'", ex);
        }
        if (fractional == null) {
            nanoAdjustment = 0;
        } else {
            try {
                nanoAdjustment = Integer.parseInt(fractional) * (int)Math.pow(10.0, 9 - fractional.length());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unexpected error in parsing: '" + fractional + "'", ex);
            }
        }
        return Instant.ofEpochSecond(epochSecond, nanoAdjustment);
    }
}

