/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.embulk.spi.Buffer;
import org.msgpack.value.ImmutableValue;

public abstract class Page {
    private static final ClassLoader CLASS_LOADER = Page.class.getClassLoader();

    public abstract Page setStringReferences(List<String> var1);

    public abstract Page setValueReferences(List<ImmutableValue> var1);

    public abstract List<String> getStringReferences();

    public abstract List<ImmutableValue> getValueReferences();

    public abstract String getStringReference(int var1);

    public abstract ImmutableValue getValueReference(int var1);

    public abstract void release();

    public abstract Buffer buffer();

    @Deprecated
    public static Page allocate(int length) {
        Buffer buffer;
        try {
            buffer = (Buffer)BufferImplHolder.CONSTRUCTOR.newInstance(new byte[length], 0, length);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
            throw new LinkageError("[FATAL] org.embulk.spi.BufferImpl is invalid.", ex);
        }
        catch (InvocationTargetException ex) {
            Page.throwCheckedForcibly(ex.getTargetException());
            return null;
        }
        try {
            return (Page)PageImplHolder.CONSTRUCTOR.newInstance(buffer);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
            throw new LinkageError("[FATAL] org.embulk.spi.PageImpl is invalid.", ex);
        }
        catch (InvocationTargetException ex) {
            Page.throwCheckedForcibly(ex.getTargetException());
            return null;
        }
    }

    @Deprecated
    public static Page wrap(Buffer buffer) {
        try {
            return (Page)PageImplHolder.CONSTRUCTOR.newInstance(buffer);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
            throw new LinkageError("[FATAL] org.embulk.spi.PageImpl is invalid.", ex);
        }
        catch (InvocationTargetException ex) {
            Page.throwCheckedForcibly(ex.getTargetException());
            return null;
        }
    }

    private static Class<Buffer> loadBufferImpl() throws ClassNotFoundException {
        return CLASS_LOADER.loadClass("org.embulk.spi.BufferImpl");
    }

    private static Class<Page> loadPageImpl() throws ClassNotFoundException {
        return CLASS_LOADER.loadClass("org.embulk.spi.PageImpl");
    }

    private static void throwCheckedForcibly(Throwable ex) {
        Page.throwCheckedForciblyInternal(ex);
    }

    private static <E extends Throwable> void throwCheckedForciblyInternal(Throwable ex) throws E {
        throw ex;
    }

    private static class PageImplHolder {
        private static final Class<Page> IMPL_CLASS;
        private static final Constructor<Page> CONSTRUCTOR;

        private PageImplHolder() {
        }

        static {
            try {
                IMPL_CLASS = Page.loadPageImpl();
            }
            catch (ClassNotFoundException ex) {
                throw new LinkageError("[FATAL] org.embulk.spi.PageImpl is not found.", ex);
            }
            try {
                CONSTRUCTOR = IMPL_CLASS.getConstructor(Buffer.class);
            }
            catch (NoSuchMethodException ex) {
                throw new LinkageError("[FATAL] org.embulk.spi.PageImpl does not have an expected constructor.", ex);
            }
        }
    }

    private static class BufferImplHolder {
        private static final Class<Buffer> IMPL_CLASS;
        private static final Constructor<Buffer> CONSTRUCTOR;

        private BufferImplHolder() {
        }

        static {
            try {
                IMPL_CLASS = Page.loadBufferImpl();
            }
            catch (ClassNotFoundException ex) {
                throw new LinkageError("[FATAL] org.embulk.spi.BufferImpl is not found.", ex);
            }
            try {
                CONSTRUCTOR = IMPL_CLASS.getConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException ex) {
                throw new LinkageError("[FATAL] org.embulk.spi.BufferImpl does not have an expected constructor.", ex);
            }
        }
    }
}

