/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi;

import java.util.Objects;
import org.embulk.spi.ColumnVisitor;
import org.embulk.spi.type.BooleanType;
import org.embulk.spi.type.DoubleType;
import org.embulk.spi.type.JsonType;
import org.embulk.spi.type.LongType;
import org.embulk.spi.type.StringType;
import org.embulk.spi.type.TimestampType;
import org.embulk.spi.type.Type;

public class Column {
    private final int index;
    private final String name;
    private final Type type;

    public Column(int index, String name, Type type) {
        this.index = index;
        this.name = name;
        this.type = type;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void visit(ColumnVisitor visitor) {
        if (this.type instanceof BooleanType) {
            visitor.booleanColumn(this);
        } else if (this.type instanceof LongType) {
            visitor.longColumn(this);
        } else if (this.type instanceof DoubleType) {
            visitor.doubleColumn(this);
        } else if (this.type instanceof StringType) {
            visitor.stringColumn(this);
        } else if (this.type instanceof TimestampType) {
            visitor.timestampColumn(this);
        } else if (this.type instanceof JsonType) {
            visitor.jsonColumn(this);
        } else {
            throw new IllegalArgumentException("Column has an unexpected type: " + this.type);
        }
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Column)) {
            return false;
        }
        Column other = (Column)otherObject;
        return Objects.equals(this.index, other.index) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.name, this.type);
    }

    public String toString() {
        return String.format("Column{index:%d, name:%s, type:%s}", this.getIndex(), this.getName(), this.getType().getName());
    }
}

