/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.settings.UpdateSecuritySettingsAction;
import org.elasticsearch.xpack.security.action.settings.TransportGetSecuritySettingsAction;

public class TransportUpdateSecuritySettingsAction
extends TransportMasterNodeAction<UpdateSecuritySettingsAction.Request, AcknowledgedResponse> {
    private final MetadataUpdateSettingsService updateSettingsService;

    @Inject
    public TransportUpdateSecuritySettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, MetadataUpdateSettingsService metadataUpdateSettingsService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(UpdateSecuritySettingsAction.INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, UpdateSecuritySettingsAction.Request::readFrom, indexNameExpressionResolver, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.updateSettingsService = metadataUpdateSettingsService;
    }

    protected void masterOperation(Task task, UpdateSecuritySettingsAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        List<UpdateSettingsClusterStateUpdateRequest> settingsUpdateRequests = Stream.of(this.createUpdateSettingsRequest(".security", Settings.builder().loadFromMap(request.mainIndexSettings()).build(), request.ackTimeout(), request.masterNodeTimeout(), state), this.createUpdateSettingsRequest(".security-tokens", Settings.builder().loadFromMap(request.tokensIndexSettings()).build(), request.ackTimeout(), request.masterNodeTimeout(), state), this.createUpdateSettingsRequest(".security-profile", Settings.builder().loadFromMap(request.profilesIndexSettings()).build(), request.ackTimeout(), request.masterNodeTimeout(), state)).filter(Optional::isPresent).map(Optional::get).toList();
        if (settingsUpdateRequests.isEmpty()) {
            assert (false) : "getting this far with an empty settings block should have been prevented by earlier request validation";
            throw new IllegalArgumentException("No settings to update");
        }
        GroupedActionListener groupedListener = new GroupedActionListener(settingsUpdateRequests.size(), ActionListener.wrap(responses -> listener.onResponse((Object)AcknowledgedResponse.of((boolean)responses.stream().allMatch(AcknowledgedResponse::isAcknowledged))), arg_0 -> listener.onFailure(arg_0)));
        settingsUpdateRequests.forEach(arg_0 -> this.lambda$masterOperation$1((ActionListener)groupedListener, arg_0));
    }

    private Optional<UpdateSettingsClusterStateUpdateRequest> createUpdateSettingsRequest(String indexName, Settings settingsToUpdate, TimeValue ackTimeout, TimeValue masterNodeTimeout, ClusterState state) {
        if (settingsToUpdate.isEmpty()) {
            return Optional.empty();
        }
        IndexAbstraction abstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(indexName);
        if (abstraction == null) {
            throw new IllegalArgumentException("the [" + indexName + "] index is not in use on this system yet");
        }
        Index writeIndex = abstraction.getWriteIndex();
        if (writeIndex == null) {
            throw new IllegalStateException(Strings.format((String)"security system alias [%s] exists but does not have a write index", (Object[])new Object[0]));
        }
        return Optional.of(new UpdateSettingsClusterStateUpdateRequest(masterNodeTimeout, ackTimeout, settingsToUpdate, UpdateSettingsClusterStateUpdateRequest.OnExisting.OVERWRITE, UpdateSettingsClusterStateUpdateRequest.OnStaticSetting.REJECT, new Index[]{writeIndex}));
    }

    protected ClusterBlockException checkBlock(UpdateSecuritySettingsAction.Request request, ClusterState state) {
        ClusterBlockException globalBlock = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (globalBlock != null) {
            return globalBlock;
        }
        ArrayList<String> indices = new ArrayList<String>(3);
        if (!request.mainIndexSettings().isEmpty()) {
            indices.add(".security");
        }
        if (!request.tokensIndexSettings().isEmpty()) {
            indices.add(".security-tokens");
        }
        if (!request.profilesIndexSettings().isEmpty()) {
            indices.add(".security-profile");
        }
        String[] concreteIndices = TransportGetSecuritySettingsAction.resolveConcreteIndices(indices, state);
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }

    private /* synthetic */ void lambda$masterOperation$1(ActionListener groupedListener, UpdateSettingsClusterStateUpdateRequest req) {
        this.updateSettingsService.updateSettings(req, groupedListener);
    }
}

