/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.RemoteInfo;
import org.elasticsearch.index.reindex.TransportReindexAction;
import org.elasticsearch.search.builder.SearchSourceBuilder;

class ReindexValidator {
    private static final Logger logger = LogManager.getLogger(ReindexValidator.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    static final String SORT_DEPRECATED_MESSAGE = "The sort option in reindex is deprecated. Instead consider using query filtering to find the desired subset of data.";
    private final CharacterRunAutomaton remoteWhitelist;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver resolver;
    private final AutoCreateIndex autoCreateIndex;

    ReindexValidator(Settings settings, ClusterService clusterService, IndexNameExpressionResolver resolver, AutoCreateIndex autoCreateIndex) {
        this.remoteWhitelist = ReindexValidator.buildRemoteWhitelist((List)TransportReindexAction.REMOTE_CLUSTER_WHITELIST.get(settings));
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.autoCreateIndex = autoCreateIndex;
    }

    void initialValidation(ReindexRequest request) {
        ReindexValidator.checkRemoteWhitelist(this.remoteWhitelist, request.getRemoteInfo());
        ClusterState state = this.clusterService.state();
        ReindexValidator.validateAgainstAliases(request.getSearchRequest(), request.getDestination(), request.getRemoteInfo(), this.resolver, this.autoCreateIndex, state);
        SearchSourceBuilder searchSource = request.getSearchRequest().source();
        if (searchSource != null && searchSource.sorts() != null && !searchSource.sorts().isEmpty()) {
            deprecationLogger.deprecatedAndMaybeLog("reindex_sort", SORT_DEPRECATED_MESSAGE, new Object[0]);
        }
    }

    static void checkRemoteWhitelist(CharacterRunAutomaton whitelist, RemoteInfo remoteInfo) {
        if (remoteInfo == null) {
            return;
        }
        String check = remoteInfo.getHost() + ':' + remoteInfo.getPort();
        if (whitelist.run(check)) {
            return;
        }
        String whiteListKey = TransportReindexAction.REMOTE_CLUSTER_WHITELIST.getKey();
        throw new IllegalArgumentException('[' + check + "] not whitelisted in " + whiteListKey);
    }

    static CharacterRunAutomaton buildRemoteWhitelist(List<String> whitelist) {
        if (whitelist.isEmpty()) {
            return new CharacterRunAutomaton(Automata.makeEmpty());
        }
        Automaton automaton = Regex.simpleMatchToAutomaton((String[])whitelist.toArray(Strings.EMPTY_ARRAY));
        if (Operations.isTotal((Automaton)(automaton = MinimizationOperations.minimize((Automaton)automaton, (int)10000)))) {
            throw new IllegalArgumentException("Refusing to start because whitelist " + whitelist + " accepts all addresses. This would allow users to reindex-from-remote any URL they like effectively having Elasticsearch make HTTP GETs for them.");
        }
        return new CharacterRunAutomaton(automaton);
    }

    static void validateAgainstAliases(SearchRequest source, IndexRequest destination, RemoteInfo remoteInfo, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex, ClusterState clusterState) {
        if (remoteInfo != null) {
            return;
        }
        String target = destination.index();
        if (!autoCreateIndex.shouldAutoCreate(target, clusterState)) {
            target = indexNameExpressionResolver.concreteWriteIndex(clusterState, (IndicesRequest)destination).getName();
        }
        for (String sourceIndex : indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)source)) {
            if (!sourceIndex.equals(target)) continue;
            ActionRequestValidationException e = new ActionRequestValidationException();
            e.addValidationError("reindex cannot write into an index its reading from [" + target + ']');
            throw e;
        }
    }
}

