/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.QueryShardContext;

public class RankFeatureFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "rank_feature";
    private final boolean positiveScoreImpact;

    private RankFeatureFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, boolean positiveScoreImpact) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.positiveScoreImpact = positiveScoreImpact;
    }

    protected RankFeatureFieldMapper clone() {
        return (RankFeatureFieldMapper)super.clone();
    }

    public RankFeatureFieldType fieldType() {
        return (RankFeatureFieldType)super.fieldType();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        float value;
        if (context.externalValueSet()) {
            Object v = context.externalValue();
            value = v instanceof Number ? ((Number)v).floatValue() : Float.parseFloat(v.toString());
        } else {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().floatValue();
        }
        if (context.doc().getByKey((Object)this.name()) != null) {
            throw new IllegalArgumentException("[rank_feature] fields do not support indexing multiple values for the same field [" + this.name() + "] in the same document");
        }
        if (!this.positiveScoreImpact) {
            value = 1.0f / value;
        }
        context.doc().addWithKey((Object)this.name(), (IndexableField)new FeatureField("_feature", this.name(), value));
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || !this.positiveScoreImpact) {
            builder.field("positive_score_impact", this.positiveScoreImpact);
        }
    }

    protected boolean docValuesByDefault() {
        return false;
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        if (this.positiveScoreImpact != ((RankFeatureFieldMapper)other).positiveScoreImpact) {
            conflicts.add("mapper [" + this.name() + "] has different [positive_score_impact] values");
        }
    }

    public static final class RankFeatureFieldType
    extends MappedFieldType {
        private final boolean positiveScoreImpact;

        public RankFeatureFieldType(String name, Map<String, String> meta, boolean positiveScoreImpact) {
            super(name, true, false, TextSearchInfo.NONE, meta);
            this.positiveScoreImpact = positiveScoreImpact;
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        public String typeName() {
            return RankFeatureFieldMapper.CONTENT_TYPE;
        }

        public boolean positiveScoreImpact() {
            return this.positiveScoreImpact;
        }

        public Query existsQuery(QueryShardContext context) {
            return new TermQuery(new Term("_feature", this.name()));
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            throw new IllegalArgumentException("[rank_feature] fields do not support sorting, scripting or aggregating");
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Queries on [rank_feature] fields are not supported");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (!propName.equals("positive_score_impact")) continue;
                builder.positiveScoreImpact(XContentMapValues.nodeBooleanValue((Object)propNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private boolean positiveScoreImpact = true;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder positiveScoreImpact(boolean v) {
            this.positiveScoreImpact = v;
            return (Builder)this.builder;
        }

        public RankFeatureFieldMapper build(Mapper.BuilderContext context) {
            return new RankFeatureFieldMapper(this.name, this.fieldType, new RankFeatureFieldType(this.buildFullName(context), this.meta, this.positiveScoreImpact), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo, this.positiveScoreImpact);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

