/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.search.TransportSearchScrollAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteByQueryAction
extends HandledTransportAction<DeleteByQueryRequest, DeleteByQueryResponse> {
    private final TransportSearchAction searchAction;
    private final TransportSearchScrollAction scrollAction;
    private final Client client;

    @Inject
    protected TransportDeleteByQueryAction(Settings settings, ThreadPool threadPool, Client client, TransportSearchAction transportSearchAction, TransportSearchScrollAction transportSearchScrollAction, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/write/delete/by_query", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteByQueryRequest.class);
        this.searchAction = transportSearchAction;
        this.scrollAction = transportSearchScrollAction;
        this.client = client;
    }

    protected void doExecute(DeleteByQueryRequest request, ActionListener<DeleteByQueryResponse> listener) {
        new AsyncDeleteByQueryAction(request, listener).start();
    }

    class AsyncDeleteByQueryAction {
        private final DeleteByQueryRequest request;
        private final ActionListener<DeleteByQueryResponse> listener;
        private final long startTime;
        private final AtomicBoolean timedOut;
        private final AtomicLong total;
        private volatile ShardOperationFailedException[] shardFailures;
        private final Map<String, IndexDeleteByQueryResponse> results;

        AsyncDeleteByQueryAction(DeleteByQueryRequest request, ActionListener<DeleteByQueryResponse> listener) {
            this.request = request;
            this.listener = listener;
            this.startTime = TransportDeleteByQueryAction.this.threadPool.estimatedTimeInMillis();
            this.timedOut = new AtomicBoolean(false);
            this.total = new AtomicLong(0L);
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
            this.results = new HashMap<String, IndexDeleteByQueryResponse>();
        }

        public void start() {
            this.executeScan();
        }

        void executeScan() {
            try {
                SearchRequest scanRequest = new SearchRequest(this.request.indices()).types(this.request.types()).indicesOptions(this.request.indicesOptions());
                scanRequest.searchType(SearchType.SCAN).scroll(this.request.scroll());
                if (this.request.routing() != null) {
                    scanRequest.routing(this.request.routing());
                }
                SearchSourceBuilder source = new SearchSourceBuilder().query(this.request.source()).fields(new String[]{"_routing", "_parent"}).fetchSource(false).version(Boolean.valueOf(true));
                if (this.request.size() > 0) {
                    source.size(this.request.size());
                }
                if (this.request.timeout() != null) {
                    source.timeout(this.request.timeout());
                }
                scanRequest.source(source);
                TransportDeleteByQueryAction.this.logger.trace("executing scan request", new Object[0]);
                TransportDeleteByQueryAction.this.searchAction.execute((ActionRequest)scanRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse searchResponse) {
                        long hits = searchResponse.getHits().getTotalHits();
                        TransportDeleteByQueryAction.this.logger.trace("scan request executed: found [{}] document(s) to delete", new Object[]{hits});
                        AsyncDeleteByQueryAction.this.addShardFailures((ShardOperationFailedException[])searchResponse.getShardFailures());
                        if (hits == 0L) {
                            AsyncDeleteByQueryAction.this.finishHim(searchResponse.getScrollId(), false, null);
                            return;
                        }
                        AsyncDeleteByQueryAction.this.total.set(hits);
                        TransportDeleteByQueryAction.this.logger.trace("start scrolling [{}] document(s)", new Object[]{hits});
                        AsyncDeleteByQueryAction.this.executeScroll(searchResponse.getScrollId());
                    }

                    public void onFailure(Throwable e) {
                        AsyncDeleteByQueryAction.this.listener.onFailure(e);
                    }
                });
            }
            catch (Throwable t) {
                TransportDeleteByQueryAction.this.logger.error("unable to execute the initial scan request of delete by query", t, new Object[0]);
                this.listener.onFailure(t);
            }
        }

        void executeScroll(final String scrollId) {
            try {
                TransportDeleteByQueryAction.this.logger.trace("executing scroll request [{}]", new Object[]{scrollId});
                TransportDeleteByQueryAction.this.scrollAction.execute((ActionRequest)new SearchScrollRequest(scrollId).scroll(this.request.scroll()), (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse scrollResponse) {
                        final SearchHit[] docs = scrollResponse.getHits().getHits();
                        final String nextScrollId = scrollResponse.getScrollId();
                        AsyncDeleteByQueryAction.this.addShardFailures((ShardOperationFailedException[])scrollResponse.getShardFailures());
                        if (TransportDeleteByQueryAction.this.logger.isTraceEnabled()) {
                            TransportDeleteByQueryAction.this.logger.trace("scroll request [{}] executed: [{}] document(s) returned", new Object[]{scrollId, docs.length});
                        }
                        if (docs.length == 0 || nextScrollId == null) {
                            TransportDeleteByQueryAction.this.logger.trace("scrolling documents terminated", new Object[0]);
                            AsyncDeleteByQueryAction.this.finishHim(scrollId, false, null);
                            return;
                        }
                        if (AsyncDeleteByQueryAction.this.hasTimedOut()) {
                            TransportDeleteByQueryAction.this.logger.trace("scrolling documents timed out", new Object[0]);
                            AsyncDeleteByQueryAction.this.finishHim(scrollId, true, null);
                            return;
                        }
                        BulkRequest bulkRequest = new BulkRequest();
                        for (SearchHit doc : docs) {
                            SearchHitField parent;
                            DeleteRequest delete = new DeleteRequest(doc.index(), doc.type(), doc.id()).version(doc.version());
                            SearchHitField routing = doc.field("_routing");
                            if (routing != null) {
                                delete.routing((String)routing.value());
                            }
                            if ((parent = doc.field("_parent")) != null) {
                                delete.parent((String)parent.value());
                            }
                            bulkRequest.add(delete);
                        }
                        TransportDeleteByQueryAction.this.logger.trace("executing bulk request with [{}] deletions", new Object[]{bulkRequest.numberOfActions()});
                        TransportDeleteByQueryAction.this.client.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

                            public void onResponse(BulkResponse bulkResponse) {
                                AsyncDeleteByQueryAction.this.onBulkResponse(nextScrollId, bulkResponse);
                            }

                            public void onFailure(Throwable e) {
                                AsyncDeleteByQueryAction.this.onBulkFailure(nextScrollId, docs, e);
                            }
                        });
                    }

                    public void onFailure(Throwable e) {
                        TransportDeleteByQueryAction.this.logger.error("scroll request [{}] failed, scrolling document(s) is stopped", e, new Object[]{scrollId});
                        AsyncDeleteByQueryAction.this.finishHim(scrollId, AsyncDeleteByQueryAction.this.hasTimedOut(), e);
                    }
                });
            }
            catch (Throwable t) {
                TransportDeleteByQueryAction.this.logger.error("unable to execute scroll request [{}]", t, new Object[]{scrollId});
                this.finishHim(scrollId, false, t);
            }
        }

        void onBulkResponse(String scrollId, BulkResponse bulkResponse) {
            try {
                for (BulkItemResponse item : bulkResponse.getItems()) {
                    IndexDeleteByQueryResponse indexCounter = this.results.get(item.getIndex());
                    if (indexCounter == null) {
                        indexCounter = new IndexDeleteByQueryResponse(item.getIndex());
                    }
                    indexCounter.incrementFound();
                    if (item.isFailed()) {
                        indexCounter.incrementFailed();
                    } else {
                        DeleteResponse delete = (DeleteResponse)item.getResponse();
                        if (delete.isFound()) {
                            indexCounter.incrementDeleted();
                        } else {
                            indexCounter.incrementMissing();
                        }
                    }
                    this.results.put(item.getIndex(), indexCounter);
                }
                TransportDeleteByQueryAction.this.logger.trace("scrolling next batch of document(s) with scroll id [{}]", new Object[]{scrollId});
                this.executeScroll(scrollId);
            }
            catch (Throwable t) {
                TransportDeleteByQueryAction.this.logger.error("unable to process bulk response", t, new Object[0]);
                this.finishHim(scrollId, false, t);
            }
        }

        void onBulkFailure(String scrollId, SearchHit[] docs, Throwable failure) {
            try {
                TransportDeleteByQueryAction.this.logger.trace("execution of scroll request failed: {}", new Object[]{failure.getMessage()});
                for (SearchHit doc : docs) {
                    IndexDeleteByQueryResponse indexCounter = this.results.get(doc.index());
                    if (indexCounter == null) {
                        indexCounter = new IndexDeleteByQueryResponse(doc.index());
                    }
                    indexCounter.incrementFound();
                    indexCounter.incrementFailed();
                    this.results.put(doc.getIndex(), indexCounter);
                }
                TransportDeleteByQueryAction.this.logger.trace("scrolling document terminated due to scroll request failure [{}]", new Object[]{scrollId});
                this.finishHim(scrollId, this.hasTimedOut(), failure);
            }
            catch (Throwable t) {
                TransportDeleteByQueryAction.this.logger.error("unable to process bulk failure", t, new Object[0]);
                this.finishHim(scrollId, false, t);
            }
        }

        void finishHim(final String scrollId, boolean scrollTimedOut, Throwable failure) {
            try {
                if (scrollTimedOut) {
                    TransportDeleteByQueryAction.this.logger.trace("delete-by-query response marked as timed out", new Object[0]);
                    this.timedOut.set(true);
                }
                if (Strings.hasText((String)scrollId)) {
                    TransportDeleteByQueryAction.this.client.prepareClearScroll().addScrollId(scrollId).execute((ActionListener)new ActionListener<ClearScrollResponse>(){

                        public void onResponse(ClearScrollResponse clearScrollResponse) {
                            TransportDeleteByQueryAction.this.logger.trace("scroll id [{}] cleared", new Object[]{scrollId});
                        }

                        public void onFailure(Throwable e) {
                            TransportDeleteByQueryAction.this.logger.warn("unable to clear scroll id [{}]: {}", new Object[]{scrollId, e.getMessage()});
                        }
                    });
                }
                if (failure != null) {
                    TransportDeleteByQueryAction.this.logger.trace("scrolling document(s) terminated with failures: {}", new Object[]{failure.getMessage()});
                    this.listener.onFailure(failure);
                } else {
                    TransportDeleteByQueryAction.this.logger.trace("scrolling document(s) terminated with success", new Object[0]);
                    this.listener.onResponse((Object)this.buildResponse());
                }
            }
            catch (Throwable t) {
                this.listener.onFailure(t);
            }
        }

        boolean hasTimedOut() {
            return this.request.timeout() != null && TransportDeleteByQueryAction.this.threadPool.estimatedTimeInMillis() >= this.startTime + this.request.timeout().millis();
        }

        void addShardFailure(ShardOperationFailedException failure) {
            this.addShardFailures(new ShardOperationFailedException[]{failure});
        }

        void addShardFailures(ShardOperationFailedException[] failures) {
            if (!CollectionUtils.isEmpty((Object[])failures)) {
                ShardOperationFailedException[] duplicates = new ShardOperationFailedException[this.shardFailures.length + failures.length];
                System.arraycopy(this.shardFailures, 0, duplicates, 0, this.shardFailures.length);
                System.arraycopy(failures, 0, duplicates, this.shardFailures.length, failures.length);
                this.shardFailures = ExceptionsHelper.groupBy((ShardOperationFailedException[])duplicates);
            }
        }

        protected DeleteByQueryResponse buildResponse() {
            long took = TransportDeleteByQueryAction.this.threadPool.estimatedTimeInMillis() - this.startTime;
            long deleted = 0L;
            long missing = 0L;
            long failed = 0L;
            for (IndexDeleteByQueryResponse result : this.results.values()) {
                deleted += result.getDeleted();
                missing += result.getMissing();
                failed += result.getFailed();
            }
            IndexDeleteByQueryResponse[] indices = this.results.values().toArray(new IndexDeleteByQueryResponse[this.results.size()]);
            return new DeleteByQueryResponse(took, this.timedOut.get(), this.total.get(), deleted, missing, failed, indices, this.shardFailures);
        }
    }
}

