/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.mocksocket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;

public class MockServerSocket
extends ServerSocket {
    public MockServerSocket() throws IOException {
    }

    public MockServerSocket(int port) throws IOException {
        super(port);
    }

    public MockServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    public MockServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
    }

    @Override
    public Socket accept() throws IOException {
        try {
            return AccessController.doPrivileged(() -> MockServerSocket.super.accept());
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                MockServerSocket.super.bind(endpoint);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

