/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.elasticsearch.tdigest.AbstractTDigest;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.Dist;

public class SortingDigest
extends AbstractTDigest {
    final ArrayList<Double> values = new ArrayList();
    private boolean isSorted = true;

    @Override
    public void add(double x, int w) {
        this.checkValue(x);
        this.isSorted = this.isSorted && (this.values.isEmpty() || this.values.get(this.values.size() - 1) <= x);
        for (int i = 0; i < w; ++i) {
            this.values.add(x);
        }
        this.max = Math.max(this.max, x);
        this.min = Math.min(this.min, x);
    }

    @Override
    public void compress() {
        if (!this.isSorted) {
            Collections.sort(this.values);
            this.isSorted = true;
        }
    }

    @Override
    public long size() {
        return this.values.size();
    }

    @Override
    public double cdf(double x) {
        this.compress();
        return Dist.cdf(x, this.values);
    }

    @Override
    public double quantile(double q) {
        this.compress();
        return Dist.quantile(q, this.values);
    }

    @Override
    public Collection<Centroid> centroids() {
        this.compress();
        return new AbstractCollection<Centroid>(){

            @Override
            public Iterator<Centroid> iterator() {
                return new Iterator<Centroid>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < SortingDigest.this.values.size();
                    }

                    @Override
                    public Centroid next() {
                        Centroid rc = new Centroid(SortingDigest.this.values.get(this.i), 1);
                        ++this.i;
                        return rc;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Default operation");
                    }
                };
            }

            @Override
            public int size() {
                return SortingDigest.this.values.size();
            }
        };
    }

    @Override
    public double compression() {
        return 1.0;
    }

    @Override
    public int centroidCount() {
        return this.centroids().size();
    }

    @Override
    public void reserve(long size) {
        int newSize = size + (long)this.values.size() > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.values.size() + (int)size;
        this.values.ensureCapacity(newSize);
    }

    @Override
    public int byteSize() {
        return this.values.size() * 8;
    }
}

