/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.Collection;
import org.elasticsearch.tdigest.AbstractTDigest;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.MergingDigest;
import org.elasticsearch.tdigest.SortingDigest;
import org.elasticsearch.tdigest.TDigest;

public class HybridDigest
extends AbstractTDigest {
    private final double compression;
    private final long maxSortingSize;
    private SortingDigest sortingDigest = new SortingDigest();
    private MergingDigest mergingDigest;

    HybridDigest(double compression, long maxSortingSize) {
        this.compression = compression;
        this.maxSortingSize = maxSortingSize;
    }

    HybridDigest(double compression) {
        this(compression, Math.round(compression) * 20L);
    }

    @Override
    public void add(double x, int w) {
        this.reserve(w);
        if (this.mergingDigest != null) {
            this.mergingDigest.add(x, w);
        } else {
            this.sortingDigest.add(x, w);
        }
    }

    @Override
    public void add(TDigest other) {
        this.reserve(other.size());
        if (this.mergingDigest != null) {
            this.mergingDigest.add(other);
        } else {
            this.sortingDigest.add(other);
        }
    }

    @Override
    public void reserve(long size) {
        if (this.mergingDigest != null) {
            this.mergingDigest.reserve(size);
            return;
        }
        assert (this.sortingDigest != null);
        if (this.sortingDigest.size() + size >= this.maxSortingSize) {
            this.mergingDigest = new MergingDigest(this.compression);
            for (double value : this.sortingDigest.values) {
                this.mergingDigest.add(value);
            }
            this.mergingDigest.reserve(size);
            this.sortingDigest = null;
        } else {
            this.sortingDigest.reserve(size);
        }
    }

    @Override
    public void compress() {
        if (this.mergingDigest != null) {
            this.mergingDigest.compress();
        } else {
            this.sortingDigest.compress();
        }
    }

    @Override
    public long size() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.size();
        }
        return this.sortingDigest.size();
    }

    @Override
    public double cdf(double x) {
        if (this.mergingDigest != null) {
            return this.mergingDigest.cdf(x);
        }
        return this.sortingDigest.cdf(x);
    }

    @Override
    public double quantile(double q) {
        if (this.mergingDigest != null) {
            return this.mergingDigest.quantile(q);
        }
        return this.sortingDigest.quantile(q);
    }

    @Override
    public Collection<Centroid> centroids() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.centroids();
        }
        return this.sortingDigest.centroids();
    }

    @Override
    public double compression() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.compression();
        }
        return this.sortingDigest.compression();
    }

    @Override
    public int centroidCount() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.centroidCount();
        }
        return this.sortingDigest.centroidCount();
    }

    @Override
    public double getMin() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.getMin();
        }
        return this.sortingDigest.getMin();
    }

    @Override
    public double getMax() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.getMax();
        }
        return this.sortingDigest.getMax();
    }

    @Override
    public int byteSize() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.byteSize();
        }
        return this.sortingDigest.byteSize();
    }
}

