/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.Collection;
import java.util.Locale;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.tdigest.AVLTreeDigest;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.HybridDigest;
import org.elasticsearch.tdigest.MergingDigest;
import org.elasticsearch.tdigest.ScaleFunction;
import org.elasticsearch.tdigest.SortingDigest;
import org.elasticsearch.tdigest.arrays.TDigestArrays;

public abstract class TDigest
implements Releasable,
Accountable {
    protected ScaleFunction scale = ScaleFunction.K_2;
    double min = Double.POSITIVE_INFINITY;
    double max = Double.NEGATIVE_INFINITY;

    public static MergingDigest createMergingDigest(TDigestArrays arrays, double compression) {
        return MergingDigest.create(arrays, compression);
    }

    public static AVLTreeDigest createAvlTreeDigest(TDigestArrays arrays, double compression) {
        return AVLTreeDigest.create(arrays, compression);
    }

    public static SortingDigest createSortingDigest(TDigestArrays arrays) {
        return SortingDigest.create(arrays);
    }

    public static HybridDigest createHybridDigest(TDigestArrays arrays, double compression) {
        return HybridDigest.create(arrays, compression);
    }

    public abstract void add(double var1, long var3);

    public final void add(double x) {
        this.add(x, 1L);
    }

    static void checkValue(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            throw new IllegalArgumentException("Invalid value: " + x);
        }
    }

    public abstract void compress();

    public abstract long size();

    public abstract double cdf(double var1);

    public abstract double quantile(double var1);

    public abstract Collection<Centroid> centroids();

    public abstract double compression();

    public abstract int byteSize();

    public void setScaleFunction(ScaleFunction scaleFunction) {
        if (scaleFunction.toString().endsWith("NO_NORM")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't use %s as scale with %s", new Object[]{scaleFunction, this.getClass()}));
        }
        this.scale = scaleFunction;
    }

    public abstract void add(TDigest var1);

    public abstract int centroidCount();

    public void reserve(long size) {
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

