/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.elasticsearch.tdigest.AVLGroupTree;
import org.elasticsearch.tdigest.AbstractTDigest;
import org.elasticsearch.tdigest.Centroid;

public class AVLTreeDigest
extends AbstractTDigest {
    final Random gen = new Random();
    private final double compression;
    private AVLGroupTree summary;
    private long count = 0L;
    private boolean needsCompression;

    public AVLTreeDigest(double compression) {
        this.compression = compression;
        this.summary = new AVLGroupTree();
    }

    public void setRandomSeed(long seed) {
        this.gen.setSeed(seed);
    }

    @Override
    public int centroidCount() {
        return this.summary.size();
    }

    @Override
    public void add(double x, long w) {
        int start;
        this.checkValue(x);
        this.needsCompression = true;
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
        if ((start = this.summary.floor(x)) == 0) {
            start = this.summary.first();
        }
        if (start == 0) {
            assert (this.summary.isEmpty());
            this.summary.add(x, w);
            this.count = w;
        } else {
            double minDistance = Double.MAX_VALUE;
            int lastNeighbor = 0;
            int neighbor = start;
            while (neighbor != 0) {
                double z = Math.abs(this.summary.mean(neighbor) - x);
                if (z < minDistance) {
                    start = neighbor;
                    minDistance = z;
                } else if (z > minDistance) {
                    lastNeighbor = neighbor;
                    break;
                }
                neighbor = this.summary.next(neighbor);
            }
            int closest = 0;
            double n = 0.0;
            long sum = this.summary.headSum(start);
            int neighbor2 = start;
            while (neighbor2 != lastNeighbor) {
                assert (minDistance == Math.abs(this.summary.mean(neighbor2) - x));
                double q = this.count == 1L ? 0.5 : ((double)sum + (double)(this.summary.count(neighbor2) - 1L) / 2.0) / (double)(this.count - 1L);
                double k = (double)(4L * this.count) * q * (1.0 - q) / this.compression;
                if ((double)(this.summary.count(neighbor2) + w) <= k) {
                    n += 1.0;
                    if (this.gen.nextDouble() < 1.0 / n) {
                        closest = neighbor2;
                    }
                }
                sum += this.summary.count(neighbor2);
                neighbor2 = this.summary.next(neighbor2);
            }
            if (closest == 0) {
                this.summary.add(x, w);
            } else {
                double centroid = this.summary.mean(closest);
                long count = this.summary.count(closest);
                centroid = AVLTreeDigest.weightedAverage(centroid, count, x, w);
                this.summary.update(closest, centroid, count += w);
            }
            this.count += w;
            if ((double)this.summary.size() > 20.0 * this.compression) {
                this.compress();
            }
        }
    }

    @Override
    public void compress() {
        int i;
        if (!this.needsCompression) {
            return;
        }
        this.needsCompression = false;
        AVLGroupTree centroids = this.summary;
        this.summary = new AVLGroupTree();
        int[] nodes = new int[centroids.size()];
        nodes[0] = centroids.first();
        for (i = 1; i < nodes.length; ++i) {
            nodes[i] = centroids.next(nodes[i - 1]);
            assert (nodes[i] != 0);
        }
        assert (centroids.next(nodes[nodes.length - 1]) == 0);
        for (i = centroids.size() - 1; i > 0; --i) {
            int other = this.gen.nextInt(i + 1);
            int tmp = nodes[other];
            nodes[other] = nodes[i];
            nodes[i] = tmp;
        }
        for (int node : nodes) {
            this.add(centroids.mean(node), centroids.count(node));
        }
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public double cdf(double x) {
        double left;
        AVLGroupTree values = this.summary;
        if (values.isEmpty()) {
            return Double.NaN;
        }
        if (values.size() == 1) {
            if (x < values.mean(values.first())) {
                return 0.0;
            }
            if (x > values.mean(values.first())) {
                return 1.0;
            }
            return 0.5;
        }
        if (x < this.min) {
            return 0.0;
        }
        if (Double.compare(x, this.min) == 0) {
            double dw = 0.0;
            for (Centroid value : values) {
                if (Double.compare(value.mean(), x) != 0) break;
                dw += (double)value.count();
            }
            return dw / 2.0 / (double)this.size();
        }
        if (x > this.max) {
            return 1.0;
        }
        if (Double.compare(x, this.max) == 0) {
            int ix = values.last();
            double dw = 0.0;
            while (ix != 0 && Double.compare(values.mean(ix), x) == 0) {
                dw += (double)values.count(ix);
                ix = values.prev(ix);
            }
            long n = this.size();
            return ((double)n - dw / 2.0) / (double)n;
        }
        Iterator<Centroid> it = values.iterator();
        Centroid a = it.next();
        Centroid b = it.next();
        double right = left = (b.mean() - a.mean()) / 2.0;
        double r = 0.0;
        while (it.hasNext()) {
            if (x < a.mean() + right) {
                double value = (r + (double)a.count() * AVLTreeDigest.interpolate(x, a.mean() - left, a.mean() + right)) / (double)this.count;
                return Math.max(value, 0.0);
            }
            r += (double)a.count();
            a = b;
            left = right;
            b = it.next();
            right = (b.mean() - a.mean()) / 2.0;
        }
        if (x < a.mean() + right) {
            return (r + (double)a.count() * AVLTreeDigest.interpolate(x, a.mean() - right, a.mean() + right)) / (double)this.count;
        }
        return 1.0;
    }

    @Override
    public double quantile(double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("q should be in [0,1], got " + q);
        }
        AVLGroupTree values = this.summary;
        if (values.isEmpty()) {
            return Double.NaN;
        }
        if (values.size() == 1) {
            return values.iterator().next().mean();
        }
        double index = q * (double)this.count;
        if (index <= 0.0) {
            return this.min;
        }
        if (index >= (double)this.count) {
            return this.max;
        }
        int currentNode = values.first();
        long currentWeight = values.count(currentNode);
        double weightSoFar = (double)currentWeight / 2.0;
        if (index <= weightSoFar && weightSoFar > 1.0) {
            return AVLTreeDigest.weightedAverage(this.min, weightSoFar - index, values.mean(currentNode), index);
        }
        for (int i = 0; i < values.size() - 1; ++i) {
            int nextNode = values.next(currentNode);
            long nextWeight = values.count(nextNode);
            double dw = (double)(currentWeight + nextWeight) / 2.0;
            if (index < weightSoFar + dw) {
                assert (dw >= 1.0);
                double w1 = index - weightSoFar;
                double w2 = weightSoFar + dw - index;
                return AVLTreeDigest.weightedAverage(values.mean(currentNode), w2, values.mean(nextNode), w1);
            }
            weightSoFar += dw;
            currentNode = nextNode;
            currentWeight = nextWeight;
        }
        assert (currentWeight >= 1L);
        assert (index - weightSoFar < (double)this.count - (double)currentWeight / 2.0);
        assert ((double)this.count - weightSoFar >= 0.5);
        double w1 = index - weightSoFar;
        double w2 = (double)currentWeight / 2.0 - w1;
        return AVLTreeDigest.weightedAverage(values.mean(currentNode), w2, this.max, w1);
    }

    @Override
    public Collection<Centroid> centroids() {
        return Collections.unmodifiableCollection(this.summary);
    }

    @Override
    public double compression() {
        return this.compression;
    }

    @Override
    public int byteSize() {
        this.compress();
        return 64 + this.summary.size() * 13;
    }
}

