/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.concurrent.atomic.AtomicInteger;

public class Centroid
implements Comparable<Centroid> {
    private static final AtomicInteger uniqueCount = new AtomicInteger(1);
    private double centroid = 0.0;
    private long count = 0L;
    private transient int id = uniqueCount.getAndIncrement();

    private Centroid() {
    }

    public Centroid(double x) {
        this();
        this.start(x, 1L, uniqueCount.getAndIncrement());
    }

    public Centroid(double x, long w) {
        this();
        this.start(x, w, uniqueCount.getAndIncrement());
    }

    public Centroid(double x, long w, int id) {
        this();
        this.start(x, w, id);
    }

    private void start(double x, long w, int id) {
        this.id = id;
        this.add(x, w);
    }

    public void add(double x, long w) {
        this.count += w;
        this.centroid += (double)w * (x - this.centroid) / (double)this.count;
    }

    public double mean() {
        return this.centroid;
    }

    public long count() {
        return this.count;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return "Centroid{centroid=" + this.centroid + ", count=" + this.count + "}";
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Centroid)) {
            return false;
        }
        return this.id == ((Centroid)o).id;
    }

    @Override
    public int compareTo(Centroid o) {
        int r = Double.compare(this.centroid, o.centroid);
        if (r == 0) {
            r = this.id - o.id;
        }
        return r;
    }
}

