/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.elasticsearch.tdigest.AbstractTDigest;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.ScaleFunction;
import org.elasticsearch.tdigest.Sort;

public class MergingDigest
extends AbstractTDigest {
    private int mergeCount = 0;
    private final double publicCompression;
    private final double compression;
    private int lastUsedCell;
    private double totalWeight = 0.0;
    private final double[] weight;
    private final double[] mean;
    private double unmergedWeight = 0.0;
    private int tempUsed = 0;
    private final double[] tempWeight;
    private final double[] tempMean;
    private final int[] order;
    public boolean useAlternatingSort = true;
    public boolean useTwoLevelCompression = true;
    public static boolean useWeightLimit = true;

    public MergingDigest(double compression) {
        this(compression, -1);
    }

    public MergingDigest(double compression, int bufferSize) {
        this(compression, bufferSize, -1);
    }

    public MergingDigest(double compression, int bufferSize, int size) {
        if (compression < 10.0) {
            compression = 10.0;
        }
        double sizeFudge = 0.0;
        if (useWeightLimit) {
            sizeFudge = 10.0;
        }
        if (bufferSize < 5 * (size = (int)Math.max(compression + sizeFudge, (double)size))) {
            bufferSize = 5 * size;
        }
        double scale = Math.max(1, bufferSize / size - 1);
        if (!this.useTwoLevelCompression) {
            scale = 1.0;
        }
        this.publicCompression = compression;
        this.compression = Math.sqrt(scale) * this.publicCompression;
        if ((double)size < this.compression + sizeFudge) {
            size = (int)Math.ceil(this.compression + sizeFudge);
        }
        if (bufferSize <= 2 * size) {
            bufferSize = 2 * size;
        }
        this.weight = new double[size];
        this.mean = new double[size];
        this.tempWeight = new double[bufferSize];
        this.tempMean = new double[bufferSize];
        this.order = new int[bufferSize];
        this.lastUsedCell = 0;
    }

    @Override
    public void add(double x, int w) {
        this.checkValue(x);
        if (this.tempUsed >= this.tempWeight.length - this.lastUsedCell - 1) {
            this.mergeNewValues();
        }
        int where = this.tempUsed++;
        this.tempWeight[where] = w;
        this.tempMean[where] = x;
        this.unmergedWeight += (double)w;
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
    }

    private void mergeNewValues() {
        this.mergeNewValues(this.compression);
    }

    private void mergeNewValues(double compression) {
        if (this.totalWeight == 0.0 && this.unmergedWeight == 0.0) {
            return;
        }
        if (this.unmergedWeight > 0.0) {
            this.merge(this.tempMean, this.tempWeight, this.tempUsed, this.order, this.unmergedWeight, this.useAlternatingSort & this.mergeCount % 2 == 1, compression);
            ++this.mergeCount;
            this.tempUsed = 0;
            this.unmergedWeight = 0.0;
        }
    }

    private void merge(double[] incomingMean, double[] incomingWeight, int incomingCount, int[] incomingOrder, double unmergedWeight, boolean runBackwards, double compression) {
        System.arraycopy(this.mean, 0, incomingMean, incomingCount, this.lastUsedCell);
        System.arraycopy(this.weight, 0, incomingWeight, incomingCount, this.lastUsedCell);
        incomingCount += this.lastUsedCell;
        if (incomingOrder == null) {
            incomingOrder = new int[incomingCount];
        }
        Sort.stableSort(incomingOrder, incomingMean, incomingCount);
        this.totalWeight += unmergedWeight;
        if (runBackwards) {
            Sort.reverse(incomingOrder, 0, incomingCount);
        }
        this.lastUsedCell = 0;
        this.mean[this.lastUsedCell] = incomingMean[incomingOrder[0]];
        this.weight[this.lastUsedCell] = incomingWeight[incomingOrder[0]];
        double wSoFar = 0.0;
        double normalizer = this.scale.normalizer(compression, this.totalWeight);
        double k1 = this.scale.k(0.0, normalizer);
        double wLimit = this.totalWeight * this.scale.q(k1 + 1.0, normalizer);
        for (int i = 1; i < incomingCount; ++i) {
            boolean addThis;
            int ix = incomingOrder[i];
            double proposedWeight = this.weight[this.lastUsedCell] + incomingWeight[ix];
            double projectedW = wSoFar + proposedWeight;
            if (useWeightLimit) {
                double q0 = wSoFar / this.totalWeight;
                double q2 = (wSoFar + proposedWeight) / this.totalWeight;
                addThis = proposedWeight <= this.totalWeight * Math.min(this.scale.max(q0, normalizer), this.scale.max(q2, normalizer));
            } else {
                boolean bl = addThis = projectedW <= wLimit;
            }
            if (i == 1 || i == incomingCount - 1) {
                addThis = false;
            }
            if (addThis) {
                int n = this.lastUsedCell;
                this.weight[n] = this.weight[n] + incomingWeight[ix];
                this.mean[this.lastUsedCell] = this.mean[this.lastUsedCell] + (incomingMean[ix] - this.mean[this.lastUsedCell]) * incomingWeight[ix] / this.weight[this.lastUsedCell];
                incomingWeight[ix] = 0.0;
                continue;
            }
            wSoFar += this.weight[this.lastUsedCell];
            if (!useWeightLimit) {
                k1 = this.scale.k(wSoFar / this.totalWeight, normalizer);
                wLimit = this.totalWeight * this.scale.q(k1 + 1.0, normalizer);
            }
            ++this.lastUsedCell;
            this.mean[this.lastUsedCell] = incomingMean[ix];
            this.weight[this.lastUsedCell] = incomingWeight[ix];
            incomingWeight[ix] = 0.0;
        }
        ++this.lastUsedCell;
        double sum = 0.0;
        for (int i = 0; i < this.lastUsedCell; ++i) {
            sum += this.weight[i];
        }
        assert (sum == this.totalWeight);
        if (runBackwards) {
            Sort.reverse(this.mean, 0, this.lastUsedCell);
            Sort.reverse(this.weight, 0, this.lastUsedCell);
        }
        if (this.totalWeight > 0.0) {
            this.min = Math.min(this.min, this.mean[0]);
            this.max = Math.max(this.max, this.mean[this.lastUsedCell - 1]);
        }
    }

    @Override
    public void compress() {
        this.mergeNewValues(this.publicCompression);
    }

    @Override
    public long size() {
        return (long)(this.totalWeight + this.unmergedWeight);
    }

    @Override
    public double cdf(double x) {
        double right;
        this.checkValue(x);
        this.mergeNewValues();
        if (this.lastUsedCell == 0) {
            return Double.NaN;
        }
        if (this.lastUsedCell == 1) {
            if (x < this.min) {
                return 0.0;
            }
            if (x > this.max) {
                return 1.0;
            }
            return 0.5;
        }
        if (x < this.min) {
            return 0.0;
        }
        if (Double.compare(x, this.min) == 0) {
            double dw = 0.0;
            for (int i = 0; i < this.lastUsedCell && Double.compare(this.mean[i], x) == 0; ++i) {
                dw += this.weight[i];
            }
            return dw / 2.0 / (double)this.size();
        }
        if (x > this.max) {
            return 1.0;
        }
        if (x == this.max) {
            double dw = 0.0;
            for (int i = this.lastUsedCell - 1; i >= 0 && Double.compare(this.mean[i], x) == 0; --i) {
                dw += this.weight[i];
            }
            return ((double)this.size() - dw / 2.0) / (double)this.size();
        }
        double left = (this.mean[1] - this.mean[0]) / 2.0;
        double weightSoFar = 0.0;
        for (int i = 0; i < this.lastUsedCell - 1; ++i) {
            right = (this.mean[i + 1] - this.mean[i]) / 2.0;
            if (x < this.mean[i] + right) {
                double value = (weightSoFar + this.weight[i] * MergingDigest.interpolate(x, this.mean[i] - left, this.mean[i] + right)) / (double)this.size();
                return Math.max(value, 0.0);
            }
            weightSoFar += this.weight[i];
            left = right;
        }
        int lastOffset = this.lastUsedCell - 1;
        right = (this.mean[lastOffset] - this.mean[lastOffset - 1]) / 2.0;
        if (x < this.mean[lastOffset] + right) {
            return (weightSoFar + this.weight[lastOffset] * MergingDigest.interpolate(x, this.mean[lastOffset] - right, this.mean[lastOffset] + right)) / (double)this.size();
        }
        return 1.0;
    }

    @Override
    public double quantile(double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("q should be in [0,1], got " + q);
        }
        this.mergeNewValues();
        if (this.lastUsedCell == 0) {
            return Double.NaN;
        }
        if (this.lastUsedCell == 1) {
            return this.mean[0];
        }
        int n = this.lastUsedCell;
        double index = q * this.totalWeight;
        if (index < 0.0) {
            return this.min;
        }
        if (index >= this.totalWeight) {
            return this.max;
        }
        double weightSoFar = this.weight[0] / 2.0;
        if (this.weight[0] > 1.0 && index < weightSoFar) {
            return MergingDigest.weightedAverage(this.min, weightSoFar - index, this.mean[0], index);
        }
        if (this.weight[n - 1] > 1.0 && this.totalWeight - index <= this.weight[n - 1] / 2.0) {
            return this.max - (this.totalWeight - index - 1.0) / (this.weight[n - 1] / 2.0 - 1.0) * (this.max - this.mean[n - 1]);
        }
        for (int i = 0; i < n - 1; ++i) {
            double dw = (this.weight[i] + this.weight[i + 1]) / 2.0;
            if (weightSoFar + dw > index) {
                double z1 = index - weightSoFar;
                double z2 = weightSoFar + dw - index;
                return MergingDigest.weightedAverage(this.mean[i], z2, this.mean[i + 1], z1);
            }
            weightSoFar += dw;
        }
        assert (this.weight[n - 1] >= 1.0);
        assert (index >= this.totalWeight - this.weight[n - 1]);
        double z1 = index - weightSoFar;
        double z2 = this.weight[n - 1] / 2.0 - z1;
        return MergingDigest.weightedAverage(this.mean[n - 1], z1, this.max, z2);
    }

    @Override
    public int centroidCount() {
        this.mergeNewValues();
        return this.lastUsedCell;
    }

    @Override
    public Collection<Centroid> centroids() {
        this.mergeNewValues();
        return new AbstractCollection<Centroid>(){

            @Override
            public Iterator<Centroid> iterator() {
                return new Iterator<Centroid>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < MergingDigest.this.lastUsedCell;
                    }

                    @Override
                    public Centroid next() {
                        Centroid rc = new Centroid(MergingDigest.this.mean[this.i], (int)MergingDigest.this.weight[this.i]);
                        ++this.i;
                        return rc;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Default operation");
                    }
                };
            }

            @Override
            public int size() {
                return MergingDigest.this.lastUsedCell;
            }
        };
    }

    @Override
    public double compression() {
        return this.publicCompression;
    }

    public ScaleFunction getScaleFunction() {
        return this.scale;
    }

    @Override
    public void setScaleFunction(ScaleFunction scaleFunction) {
        super.setScaleFunction(scaleFunction);
    }

    @Override
    public int byteSize() {
        return 48 + 8 * (this.mean.length + this.weight.length + this.tempMean.length + this.tempWeight.length) + 4 * this.order.length;
    }

    public String toString() {
        return "MergingDigest-" + this.getScaleFunction() + "-" + (useWeightLimit ? "weight" : "kSize") + "-" + (this.useAlternatingSort ? "alternating" : "stable") + "-" + (this.useTwoLevelCompression ? "twoLevel" : "oneLevel");
    }
}

