/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.webtemplate.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class WebTemplateUtils {
    private WebTemplateUtils() {
    }

    public static boolean isChoiceDvCodedTextAndDvText(WebTemplateNode node) {
        List childrenIds = WebTemplateUtils.getTrueChildrenElement(node).stream().map(WebTemplateNode::getId).collect(Collectors.toList());
        return childrenIds.size() == 2 && childrenIds.containsAll(List.of("coded_text_value", "text_value")) && node.getChoicesInChildren().size() > 0;
    }

    public static List<WebTemplateNode> getTrueChildrenElement(WebTemplateNode node) {
        if (!"ELEMENT".equals(node.getRmType())) {
            return Collections.emptyList();
        }
        return node.getChildren().stream().filter(childNode -> !"name".equals(childNode.getName())).filter(childNode -> !List.of("null_flavour", "feeder_audit").contains(childNode.getName()) || !childNode.isNullable()).collect(Collectors.toList());
    }

    public static <T> List<T> cloneList(List<T> list, UnaryOperator<T> elementCloner) {
        ArrayList clonedList = new ArrayList(list.size());
        for (T el : list) {
            clonedList.add(elementCloner.apply(el));
        }
        return clonedList;
    }

    public static <K, V> LinkedHashMap<K, V> cloneMap(Map<K, V> map, UnaryOperator<V> valueCloner) {
        if (map.isEmpty()) {
            return new LinkedHashMap();
        }
        LinkedHashMap newMap = new LinkedHashMap(map.size() * 4 / 3 + 1, 0.75f);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            newMap.put(entry.getKey(), valueCloner.apply(entry.getValue()));
        }
        return newMap;
    }
}

