/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.webtemplate.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.webtemplate.model.ProportionType;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateAnnotation;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateTerminology;
import org.ehrbase.openehr.sdk.webtemplate.model.WebtemplateCardinality;
import org.ehrbase.openehr.sdk.webtemplate.util.WebTemplateUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class WebTemplateNode
implements Serializable {
    private static final ArchieRMInfoLookup RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private String id;
    @JsonIgnore
    private Integer optionalIdNumber;
    private boolean archetypeSlot = false;
    private String name;
    private String localizedName;
    private String rmType;
    private String nodeId;
    private int min;
    private int max;
    private final Map<String, String> localizedNames;
    private final Map<String, String> localizedDescriptions;
    @JsonIgnore
    private final String[] aqlCache = new String[2];
    private AqlPath aqlPath;
    private final List<WebTemplateNode> children;
    private final List<WebTemplateInput> inputs;
    private Boolean inContext;
    private final Map<String, WebTemplateTerminology> termBindings;
    private final List<String> dependsOn;
    private WebTemplateAnnotation annotations;
    private final List<ProportionType> proportionTypes;
    private final List<WebtemplateCardinality> cardinalities;

    public WebTemplateNode() {
        this.localizedNames = new LinkedHashMap<String, String>();
        this.localizedDescriptions = new LinkedHashMap<String, String>();
        this.children = new ArrayList<WebTemplateNode>();
        this.inputs = new ArrayList<WebTemplateInput>();
        this.termBindings = new LinkedHashMap<String, WebTemplateTerminology>();
        this.proportionTypes = new ArrayList<ProportionType>();
        this.dependsOn = new ArrayList<String>();
        this.cardinalities = new ArrayList<WebtemplateCardinality>();
    }

    public WebTemplateNode(WebTemplateNode other) {
        this.id = other.id;
        this.optionalIdNumber = other.optionalIdNumber;
        this.name = other.name;
        this.localizedName = other.localizedName;
        this.rmType = other.rmType;
        this.nodeId = other.nodeId;
        this.min = other.min;
        this.max = other.max;
        this.aqlPath = other.aqlPath;
        this.aqlCache[0] = other.getAqlPath(true);
        this.aqlCache[1] = other.getAqlPath(false);
        this.inContext = other.inContext;
        this.archetypeSlot = other.archetypeSlot;
        this.dependsOn = new ArrayList<String>(other.dependsOn);
        if (other.annotations != null) {
            this.annotations = new WebTemplateAnnotation(other.annotations);
        }
        this.cardinalities = WebTemplateUtils.cloneList(other.cardinalities, WebtemplateCardinality::new);
        this.inputs = WebTemplateUtils.cloneList(other.inputs, WebTemplateInput::new);
        this.children = WebTemplateUtils.cloneList(other.children, WebTemplateNode::new);
        this.localizedNames = new LinkedHashMap<String, String>(other.localizedNames);
        this.localizedDescriptions = new LinkedHashMap<String, String>(other.localizedDescriptions);
        this.proportionTypes = new ArrayList<ProportionType>(other.getProportionTypes());
        this.termBindings = WebTemplateUtils.cloneMap(other.termBindings, WebTemplateTerminology::new);
    }

    public String getId() {
        return this.getId(true);
    }

    public String getId(boolean withOptionalIdNumber) {
        if (withOptionalIdNumber && this.optionalIdNumber != null) {
            return this.id + this.optionalIdNumber;
        }
        return this.id;
    }

    public void setOptionalIdNumber(Integer optionalIdNumber) {
        this.optionalIdNumber = optionalIdNumber;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    public String getRmType() {
        return this.rmType;
    }

    public void setRmType(String rmType) {
        this.rmType = rmType;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public Map<String, String> getLocalizedNames() {
        return this.localizedNames;
    }

    public Map<String, String> getLocalizedDescriptions() {
        return this.localizedDescriptions;
    }

    public String getAqlPath() {
        return this.getAqlPath(true);
    }

    @JsonIgnore
    public AqlPath getAqlPathDto() {
        return this.aqlPath;
    }

    public String getAqlPath(boolean withOtherPredicates) {
        int idx;
        int n = idx = withOtherPredicates ? 0 : 1;
        if (this.aqlCache[idx] == null) {
            this.aqlCache[idx] = this.aqlPath.format(withOtherPredicates);
        }
        return this.aqlCache[idx];
    }

    public void setAqlPath(String aqlPath) {
        this.setAqlPath(AqlPath.parse((String)aqlPath));
    }

    public void setAqlPath(AqlPath aqlPath) {
        this.aqlPath = aqlPath;
        Arrays.fill(this.aqlCache, null);
    }

    public List<WebTemplateNode> getChildren() {
        return this.children;
    }

    public List<WebtemplateCardinality> getCardinalities() {
        return this.cardinalities;
    }

    @JsonIgnore
    public Map<String, List<WebTemplateNode>> getChoicesInChildren() {
        return this.children.stream().collect(Collectors.groupingBy(WebTemplateNode::getAqlPath)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public List<WebTemplateInput> getInputs() {
        return this.inputs;
    }

    public Boolean getInContext() {
        return this.inContext;
    }

    public void setInContext(Boolean inContext) {
        this.inContext = inContext;
    }

    public Map<String, WebTemplateTerminology> getTermBindings() {
        return this.termBindings;
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public WebTemplateAnnotation getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(WebTemplateAnnotation annotations) {
        this.annotations = annotations;
    }

    public List<ProportionType> getProportionTypes() {
        return this.proportionTypes;
    }

    public Optional<WebTemplateNode> findChildById(String id) {
        return this.children.stream().filter(n -> n.getId().equals(id)).findAny();
    }

    public AqlPath buildRelativePath(WebTemplateNode child, boolean checkIfTrueChild) {
        if (checkIfTrueChild) {
            return child.aqlPath.removeStart(this.aqlPath);
        }
        AqlPath me = this.aqlPath;
        AqlPath other = child.aqlPath;
        if (!me.hasPath()) {
            return other;
        }
        return other.getEnd(other.getNodeCount() - me.getNodeCount());
    }

    public boolean isRelativePathNameDependent(WebTemplateNode child) {
        return WebTemplateNode.isNameDependent(this.buildRelativePath(child, false));
    }

    public static boolean isNameDependent(AqlPath aqlPath) {
        return aqlPath.getLastNode().findOtherPredicate("name/value") != null;
    }

    public List<WebTemplateNode> findMatching(Predicate<WebTemplateNode> filter) {
        return this.streamMatching(filter).collect(Collectors.toList());
    }

    public Stream<WebTemplateNode> streamMatching(Predicate<WebTemplateNode> filter) {
        Stream<WebTemplateNode> matching = this.children.stream().flatMap(c -> c.streamMatching(filter));
        if (filter.test(this)) {
            matching = Stream.concat(matching, Stream.of(this));
        }
        return matching;
    }

    public static Stream<WebTemplateNode> streamSubtree(WebTemplateNode node, boolean depthFirst) {
        return WebTemplateNode.streamSubtree(List.of(node), depthFirst);
    }

    public static Stream<WebTemplateNode> streamSubtree(List<WebTemplateNode> nodes, boolean depthFirst) {
        if (nodes.isEmpty()) {
            return Stream.of(new WebTemplateNode[0]);
        }
        if (depthFirst) {
            return Stream.concat(nodes.stream().flatMap(n -> WebTemplateNode.streamSubtree(n.getChildren(), true)), nodes.stream());
        }
        return Stream.concat(nodes.stream(), nodes.stream().flatMap(n -> WebTemplateNode.streamSubtree(n.getChildren(), false)));
    }

    public List<WebTemplateNode> multiValued() {
        List<WebTemplateNode> matching = this.children.stream().map(WebTemplateNode::multiValued).flatMap(Collection::stream).collect(Collectors.toList());
        if (this.max != 1) {
            matching.add(this);
        }
        Map<String, List<WebTemplateNode>> collect = this.children.stream().collect(Collectors.groupingBy(n -> n.getAqlPathDto().format(false)));
        collect.forEach((k, v) -> {
            if (v.size() > 1) {
                matching.addAll(v.stream().filter(n -> n.max == 1).collect(Collectors.toList()));
            }
        });
        return matching;
    }

    @JsonIgnore
    public boolean isArchetype() {
        return RM_INFO_LOOKUP.getTypeInfo(this.getRmType()) != null && Locatable.class.isAssignableFrom(RM_INFO_LOOKUP.getTypeInfo(this.getRmType()).getJavaClass()) && !StringUtils.startsWith((CharSequence)this.getNodeId(), (CharSequence)"at");
    }

    @JsonIgnore
    public boolean isArchetypeSlot() {
        return this.archetypeSlot;
    }

    @JsonIgnore
    public boolean isNullable() {
        return this.min == 0;
    }

    @JsonIgnore
    public boolean isMulti() {
        return this.max != 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebTemplateNode that = (WebTemplateNode)o;
        return this.min == that.min && this.max == that.max && Objects.equals(this.id, that.id) && Objects.equals(this.optionalIdNumber, that.optionalIdNumber) && Objects.equals(this.name, that.name) && Objects.equals(this.localizedName, that.localizedName) && Objects.equals(this.rmType, that.rmType) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.localizedNames, that.localizedNames) && Objects.equals(this.localizedDescriptions, that.localizedDescriptions) && Objects.equals(this.aqlPath, that.aqlPath) && Objects.equals(this.children, that.children) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.inContext, that.inContext) && Objects.equals(this.termBindings, that.termBindings) && Objects.equals(this.dependsOn, that.dependsOn) && Objects.equals(this.annotations, that.annotations) && Objects.equals(this.proportionTypes, that.proportionTypes) && Objects.equals(this.cardinalities, that.cardinalities);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.optionalIdNumber, this.name, this.localizedName, this.rmType, this.nodeId, this.min, this.max, this.localizedNames, this.localizedDescriptions, this.aqlPath, this.children, this.inputs, this.inContext, this.termBindings, this.dependsOn, this.annotations, this.proportionTypes, this.cardinalities);
    }

    public String toString() {
        return "WebTemplateNode{id='" + this.id + "', name='" + this.name + "', rmType='" + this.rmType + "', aqlPath='" + this.aqlPath + "'}";
    }

    public void setArchetypeSlot(boolean archetypeSlot) {
        this.archetypeSlot = archetypeSlot;
    }
}

