/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FromCompositionWalker;
import org.ehrbase.openehr.sdk.util.reflection.ReflectionHelper;
import org.ehrbase.openehr.sdk.validation.ConstraintViolation;
import org.ehrbase.openehr.sdk.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.openehr.sdk.validation.webtemplate.ConstraintValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.DefaultValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.DvCodedTextValidator;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationWalker
extends FromCompositionWalker<List<ConstraintViolation>> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Map<Class<? extends RMObject>, ConstraintValidator> VALIDATORS = ReflectionHelper.buildMap(ConstraintValidator.class);
    private final DefaultValidator defaultValidator = new DefaultValidator();
    private final boolean checkForChildrenNotInTemplate;

    public ValidationWalker(ExternalTerminologyValidation externalTerminologyValidation, boolean checkForChildrenNotInTemplate) {
        if (externalTerminologyValidation != null) {
            VALIDATORS.put(DvCodedText.class, new DvCodedTextValidator(externalTerminologyValidation));
        }
        this.checkForChildrenNotInTemplate = checkForChildrenNotInTemplate;
    }

    protected void preHandle(Context<List<ConstraintViolation>> context) {
        WebTemplateNode node = (WebTemplateNode)context.getNodeDeque().element();
        RMObject rmObject = (RMObject)context.getRmObjectDeque().element();
        this.logger.trace("PreHandle: {}, rmObject={}", (Object)node, (Object)rmObject);
        List<ConstraintViolation> toBeAdded = this.getValidator(rmObject).validate(rmObject, node);
        if (!toBeAdded.isEmpty()) {
            List result = (List)context.getObjectDeque().element();
            result.addAll(toBeAdded);
        }
    }

    protected List<ConstraintViolation> extract(Context<List<ConstraintViolation>> context, WebTemplateNode child, BooleanSupplier isChoice, Integer i) {
        return (List)context.getObjectDeque().peek();
    }

    protected void postHandle(Context<List<ConstraintViolation>> context) {
    }

    protected void handleChildrenNotInTemplate(Context<List<ConstraintViolation>> context, String attributeName, Locatable locatable) {
        WebTemplateNode peek = (WebTemplateNode)context.getNodeDeque().peek();
        boolean foundArchetypeSlot = peek.getChildren().stream().filter(WebTemplateNode::isArchetypeSlot).filter(n -> Objects.equals(n.getAqlPathDto().getLastNode().getName(), attributeName)).filter(n -> {
            String otherPredicate = n.getAqlPathDto().getLastNode().findOtherPredicate("name/value");
            return otherPredicate == null || otherPredicate.equals(locatable.getName().getValue());
        }).anyMatch(c -> locatable.getArchetypeNodeId().startsWith("openEHR-EHR-" + c.getRmType() + "."));
        if (!foundArchetypeSlot) {
            ((List)context.getObjectDeque().peek()).add(new ConstraintViolation(peek.getAqlPath(), "RmObject with type:%s, nodeId:%s,name:%s; not in template".formatted(locatable.getClass().getSimpleName(), locatable.getArchetypeNodeId(), locatable.getName().getValue())));
        }
    }

    private <T extends RMObject> ConstraintValidator<T> getValidator(RMObject object) {
        return VALIDATORS.getOrDefault(object.getClass(), this.defaultValidator);
    }

    protected void postVisitChildren(Context<List<ConstraintViolation>> context, WebTemplateNode currentNode) {
        if (this.checkForChildrenNotInTemplate) {
            Stream<Pair<String, Locatable>> childrenNotInTemplate = this.findChildrenNotInTemplate(context, currentNode);
            childrenNotInTemplate.forEach(c -> this.handleChildrenNotInTemplate(context, (String)c.getLeft(), (Locatable)c.getRight()));
        }
    }

    protected <T> Stream<? extends Pair<String, Locatable>> findChildrenNotInTemplate(Context<T> context, WebTemplateNode currentNode) {
        RMObject curentRmObject = (RMObject)context.getRmObjectDeque().peek();
        return ValidationWalker.getChildLocatable(curentRmObject).filter(Objects::nonNull).filter(c -> currentNode.getChildren().stream().filter(n -> !n.isArchetypeSlot()).noneMatch(n -> ValidationWalker.matches((String)c.getLeft(), (Locatable)c.getRight(), n)));
    }

    private static boolean matches(String attributeName, Locatable locatable, WebTemplateNode n) {
        AqlPath.AqlNode lastNode = n.getAqlPathDto().getLastNode();
        if (!attributeName.equals(lastNode.getName())) {
            return false;
        }
        if (!Objects.equals(n.getNodeId(), locatable.getArchetypeNodeId())) {
            return false;
        }
        String otherPredicate = lastNode.findOtherPredicate("name/value");
        return otherPredicate == null || otherPredicate.equals(locatable.getName().getValue());
    }

    private static Stream<? extends Pair<String, Locatable>> getChildLocatable(RMObject curentRmObject) {
        return ArchieRMInfoLookup.getInstance().getTypeInfo(curentRmObject.getClass()).getAttributes().values().stream().filter(s -> !s.isComputed()).filter(s -> Locatable.class.isAssignableFrom(s.getTypeInCollection())).flatMap(a -> {
            Object invoke;
            try {
                invoke = a.getGetMethod().invoke((Object)curentRmObject, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (invoke == null) {
                return Stream.empty();
            }
            if (invoke instanceof Collection) {
                Collection c = (Collection)invoke;
                return c.stream().map(Locatable.class::cast).map(l -> Pair.of((Object)a.getRmName(), (Object)l));
            }
            return Stream.of(invoke).map(Locatable.class::cast).map(l -> Pair.of((Object)a.getRmName(), (Object)l));
        });
    }
}

