/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.primitives.CBoolean;
import com.nedap.archie.aom.primitives.CDate;
import com.nedap.archie.aom.primitives.CDateTime;
import com.nedap.archie.aom.primitives.CInteger;
import com.nedap.archie.aom.primitives.CReal;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.aom.primitives.CTime;
import com.nedap.archie.base.Interval;
import com.nedap.archie.datetime.DateTimeParsers;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import org.ehrbase.openehr.sdk.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateComparisonSymbol;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInterval;

public class PrimitiveConstraintMapper {
    public CPrimitiveObject<?, ?> mapInput(WebTemplateInput input) {
        if (input == null) {
            return null;
        }
        switch (input.getType()) {
            case "BOOLEAN": {
                return this.mapBooleanInput(input);
            }
            case "TEXT": {
                return this.mapTextInput(input);
            }
            case "INTEGER": {
                return this.mapIntegerInput(input);
            }
            case "DECIMAL": {
                return this.mapRealInput(input);
            }
            case "DATE": {
                return this.mapDateInput(input);
            }
            case "TIME": {
                return this.mapTimeInput(input);
            }
            case "DATETIME": {
                return this.mapDateTimeInput(input);
            }
        }
        throw new IllegalStateException("Unsupported input type: " + input.getType());
    }

    public CBoolean mapBooleanInput(WebTemplateInput input) {
        CBoolean cBoolean = new CBoolean();
        input.getList().stream().map(inputValue -> Boolean.valueOf(inputValue.getValue())).forEach(arg_0 -> ((CBoolean)cBoolean).addConstraint(arg_0));
        return cBoolean;
    }

    public CString mapTextInput(WebTemplateInput input) {
        CString cString = new CString();
        if (WebTemplateValidationUtils.hasValidationPattern(input)) {
            cString.addConstraint(input.getValidation().getPattern());
        }
        if (WebTemplateValidationUtils.hasList(input)) {
            input.getList().stream().map(WebTemplateInputValue::getValue).forEach(arg_0 -> ((CString)cString).addConstraint(arg_0));
        }
        return cString;
    }

    public CInteger mapIntegerInput(WebTemplateInput input) {
        CInteger cInteger = new CInteger();
        input.getList().stream().map(inputValue -> new Interval((Object)Long.valueOf(inputValue.getValue()))).forEach(arg_0 -> ((CInteger)cInteger).addConstraint(arg_0));
        if (WebTemplateValidationUtils.hasValidationRange(input)) {
            Interval<Long> interval = this.mapIntervalOfInteger(input.getValidation().getRange());
            cInteger.addConstraint(interval);
        }
        return cInteger;
    }

    public CReal mapRealInput(WebTemplateInput input) {
        CReal cReal = new CReal();
        input.getList().stream().map(inputValue -> new Interval((Object)Double.valueOf(inputValue.getValue()))).forEach(arg_0 -> ((CReal)cReal).addConstraint(arg_0));
        if (WebTemplateValidationUtils.hasValidationRange(input)) {
            Interval<Double> interval = this.mapIntervalOfReal(input.getValidation().getRange());
            cReal.addConstraint(interval);
        }
        return cReal;
    }

    public CDate mapDateInput(WebTemplateInput input) {
        CDate cDate = new CDate();
        if (WebTemplateValidationUtils.hasValidationRange(input)) {
            Interval<Temporal> interval = this.mapIntervalOfDate(input.getValidation().getRange());
            cDate.addConstraint(interval);
        }
        if (WebTemplateValidationUtils.hasValidationPattern(input)) {
            cDate.setPatternConstraint(input.getValidation().getPattern());
        }
        return cDate;
    }

    public CDateTime mapDateTimeInput(WebTemplateInput input) {
        CDateTime cDateTime = new CDateTime();
        if (WebTemplateValidationUtils.hasValidationRange(input)) {
            Interval<TemporalAccessor> interval = this.mapIntervalOfDateTime(input.getValidation().getRange());
            cDateTime.addConstraint(interval);
        }
        if (WebTemplateValidationUtils.hasValidationPattern(input)) {
            cDateTime.setPatternConstraint(input.getValidation().getPattern());
        }
        return cDateTime;
    }

    public CTime mapTimeInput(WebTemplateInput input) {
        CTime cTime = new CTime();
        if (WebTemplateValidationUtils.hasValidationRange(input)) {
            Interval<TemporalAccessor> interval = this.mapIntervalOfTime(input.getValidation().getRange());
            cTime.addConstraint(interval);
        }
        if (WebTemplateValidationUtils.hasValidationPattern(input)) {
            cTime.setPatternConstraint(input.getValidation().getPattern());
        }
        return cTime;
    }

    public CInteger mapIntegerInterval(WebTemplateInterval<?> interval) {
        CInteger cInteger = new CInteger();
        cInteger.addConstraint(this.mapIntervalOfInteger(interval));
        return cInteger;
    }

    public CReal mapRealInterval(WebTemplateInterval<?> interval) {
        CReal cReal = new CReal();
        cReal.addConstraint(this.mapIntervalOfReal(interval));
        return cReal;
    }

    private Interval<Long> mapIntervalOfInteger(WebTemplateInterval<?> interval) {
        Long lower = null;
        if (interval.getMin() instanceof Number) {
            lower = ((Number)interval.getMin()).longValue();
        }
        Long upper = null;
        if (interval.getMax() instanceof Number) {
            upper = ((Number)interval.getMax()).longValue();
        }
        return new Interval((Object)lower, (Object)upper, this.isLowerIncluded(interval), this.isUpperIncluded(interval));
    }

    private Interval<Double> mapIntervalOfReal(WebTemplateInterval<?> interval) {
        Double lower = null;
        if (interval.getMin() instanceof Number) {
            lower = ((Number)interval.getMin()).doubleValue();
        }
        Double upper = null;
        if (interval.getMax() instanceof Number) {
            upper = ((Number)interval.getMax()).doubleValue();
        }
        return new Interval((Object)lower, (Object)upper, this.isLowerIncluded(interval), this.isUpperIncluded(interval));
    }

    private Interval<Temporal> mapIntervalOfDate(WebTemplateInterval<?> interval) {
        Temporal lower = null;
        if (interval.getMin() instanceof String) {
            lower = DateTimeParsers.parseDateValue((String)((String)((Object)interval.getMin())));
        }
        Temporal upper = null;
        if (interval.getMax() instanceof String) {
            upper = DateTimeParsers.parseDateValue((String)((String)((Object)interval.getMax())));
        }
        return new Interval((Object)lower, (Object)upper, this.isLowerIncluded(interval), this.isUpperIncluded(interval));
    }

    private Interval<TemporalAccessor> mapIntervalOfDateTime(WebTemplateInterval<?> interval) {
        TemporalAccessor lower = null;
        if (interval.getMin() instanceof String) {
            lower = DateTimeParsers.parseDateTimeValue((String)((String)((Object)interval.getMin())));
        }
        TemporalAccessor upper = null;
        if (interval.getMin() instanceof String) {
            upper = DateTimeParsers.parseDateTimeValue((String)((String)((Object)interval.getMax())));
        }
        return new Interval((Object)lower, (Object)upper, this.isLowerIncluded(interval), this.isUpperIncluded(interval));
    }

    private Interval<TemporalAccessor> mapIntervalOfTime(WebTemplateInterval<?> interval) {
        TemporalAccessor lower = null;
        if (interval.getMin() instanceof String) {
            lower = DateTimeParsers.parseTimeValue((String)((String)((Object)interval.getMin())));
        }
        TemporalAccessor upper = null;
        if (interval.getMin() instanceof String) {
            upper = DateTimeParsers.parseTimeValue((String)((String)((Object)interval.getMax())));
        }
        return new Interval((Object)lower, (Object)upper, this.isLowerIncluded(interval), this.isUpperIncluded(interval));
    }

    private boolean isLowerIncluded(WebTemplateInterval<?> interval) {
        return interval.getMinOp() == null || interval.getMinOp() == WebTemplateComparisonSymbol.GT_EQ;
    }

    private boolean isUpperIncluded(WebTemplateInterval<?> interval) {
        return interval.getMaxOp() == null || interval.getMaxOp() == WebTemplateComparisonSymbol.LT_EQ;
    }
}

