/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.nedap.archie.rm.composition.IsmTransition;
import com.nedap.archie.rm.datavalues.DvCodedText;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.State;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.Transition;
import org.ehrbase.openehr.sdk.validation.ConstraintViolation;
import org.ehrbase.openehr.sdk.validation.webtemplate.ConstraintValidator;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class IsmTransitionValidator
implements ConstraintValidator<IsmTransition> {
    public Class<IsmTransition> getAssociatedClass() {
        return IsmTransition.class;
    }

    @Override
    public List<ConstraintViolation> validate(IsmTransition transition, WebTemplateNode node) {
        return ConstraintValidator.concat(CurrentStateValidator.apply(transition, node), CareFlowValidator.apply(transition, node));
    }

    private static String ismToString(IsmTransition ism) {
        return "%s/%s/%s".formatted(ism.getTransition().getValue(), ism.getTransition().getDefiningCode().getTerminologyId().getValue(), ism.getTransition().getDefiningCode().getCodeString());
    }

    private static class CurrentStateValidator {
        private static final String ERR_NO_VALID_TRANSITION = "No valid transition found for ism transition[%s]";

        private CurrentStateValidator() {
        }

        public static Stream<ConstraintViolation> apply(IsmTransition ismTransition, WebTemplateNode node) {
            DvCodedText transition = ismTransition.getTransition();
            if (transition == null) {
                return Stream.empty();
            }
            return CurrentStateValidator.candidates(Transition.class, t -> t.getValue().equals(transition.getValue()), t -> t.getTerminologyId().equals(transition.getDefiningCode().getTerminologyId().getValue()), t -> t.getCode().equals(transition.getDefiningCode().getCodeString())).filter(t -> !CurrentStateValidator.isValidTransition(ismTransition, t)).map(p -> new ConstraintViolation(node.getAqlPath(), String.format(ERR_NO_VALID_TRANSITION, IsmTransitionValidator.ismToString(ismTransition))));
        }

        private static boolean isValidTransition(IsmTransition ism, Transition transition) {
            State targetState = transition.getTargetState();
            DvCodedText currentState = ism.getCurrentState();
            return targetState.getValue().equals(currentState.getValue()) && targetState.getTerminologyId().equals(currentState.getDefiningCode().getTerminologyId().getValue()) && targetState.getCode().equals(currentState.getDefiningCode().getCodeString());
        }

        private static <E extends Enum<E>> Stream<E> candidates(Class<E> type, Predicate<E> ... pred) {
            Predicate<Enum> passAll = t -> {
                for (Predicate ePredicate : pred) {
                    if (ePredicate.test(t)) continue;
                    return false;
                }
                return true;
            };
            return EnumSet.allOf(type).stream().filter(passAll);
        }
    }

    private static class CareFlowValidator {
        private CareFlowValidator() {
        }

        public static Stream<ConstraintViolation> apply(IsmTransition transition, WebTemplateNode node) {
            if (transition.getTransition() == null || transition.getCareflowStep() == null) {
                return Stream.empty();
            }
            Iterator<WebTemplateNode> cfStepIt = CareFlowValidator.iterateCareflowSteps(node);
            if (cfStepIt.hasNext()) {
                WebTemplateNode cfStep = cfStepIt.next();
                if (cfStepIt.hasNext()) {
                    return Stream.of(new ConstraintViolation(node.getAqlPath(), "Specification violation[too many careflow_step]"));
                }
                boolean isValid = Stream.of(cfStep).map(WebTemplateNode::getInputs).flatMap(Collection::stream).map(WebTemplateInput::getList).flatMap(Collection::stream).filter(tmpl -> CareFlowValidator.isMatchingCareflowStep(transition.getCareflowStep(), tmpl.getValue())).anyMatch(tmpl -> CareFlowValidator.isCurrentStateValid(transition.getCurrentState(), tmpl.getCurrentStates()));
                return isValid ? Stream.empty() : Stream.of(new ConstraintViolation(node.getAqlPath(), "IsmTransition contains invalid current_state"));
            }
            return Stream.of(new ConstraintViolation[0]);
        }

        private static boolean isMatchingCareflowStep(DvCodedText cfsFromIsm, String codeFromWTV) {
            return cfsFromIsm.getDefiningCode().getCodeString().equals(codeFromWTV);
        }

        private static boolean isCurrentStateValid(DvCodedText currentState, List<String> allowedStates) {
            return allowedStates.contains(currentState.getDefiningCode().getCodeString());
        }

        private static Iterator<WebTemplateNode> iterateCareflowSteps(WebTemplateNode node) {
            return node.getChildren().stream().filter(n -> n.getAqlPath() != null).filter(n -> n.getAqlPath().endsWith("careflow_step")).iterator();
        }
    }
}

