/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.rm.datavalues.quantity.DvQuantity;
import java.util.List;
import java.util.Optional;
import org.ehrbase.openehr.sdk.validation.ConstraintViolation;
import org.ehrbase.openehr.sdk.validation.webtemplate.ConstraintValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.PrimitiveConstraintMapper;
import org.ehrbase.openehr.sdk.validation.webtemplate.PrimitiveConstraintValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class DvQuantityValidator
implements ConstraintValidator<DvQuantity> {
    private static final PrimitiveConstraintMapper CONSTRAINT_MAPPER = new PrimitiveConstraintMapper();

    public Class<DvQuantity> getAssociatedClass() {
        return DvQuantity.class;
    }

    @Override
    public List<ConstraintViolation> validate(DvQuantity quantity, WebTemplateNode node) {
        return ConstraintValidator.concat(WebTemplateValidationUtils.findInputWithSuffix(node, "magnitude").map(input -> this.validateMagnitude(node.getAqlPath(), quantity, (WebTemplateInput)input)).orElse(List.of()), WebTemplateValidationUtils.findInputWithSuffix(node, "unit").map(input -> this.validateUnit(node.getAqlPath(), quantity, (WebTemplateInput)input)).orElse(List.of()));
    }

    private List<ConstraintViolation> validateMagnitude(String path, DvQuantity quantity, WebTemplateInput input) {
        return PrimitiveConstraintValidator.validate(path, (Object)quantity.getMagnitude(), input);
    }

    private List<ConstraintViolation> validateUnit(String path, DvQuantity quantity, WebTemplateInput unitInput) {
        CString cString = CONSTRAINT_MAPPER.mapTextInput(unitInput);
        List<ConstraintViolation> violations = PrimitiveConstraintValidator.validate(path, (Object)quantity.getUnits(), cString);
        if (!violations.isEmpty()) {
            return violations;
        }
        Optional<WebTemplateInputValue> inputValue = WebTemplateValidationUtils.findInputValue(unitInput, quantity.getUnits());
        return inputValue.map(unitValue -> ConstraintValidator.concat(this.validateRange(path, quantity, (WebTemplateInputValue)unitValue), this.validatePrecision(path, quantity, (WebTemplateInputValue)unitValue))).orElse(List.of());
    }

    private List<ConstraintViolation> validateRange(String path, DvQuantity quantity, WebTemplateInputValue unitValue) {
        if (WebTemplateValidationUtils.hasValidationRange(unitValue)) {
            return PrimitiveConstraintValidator.validate(path, (Object)quantity.getMagnitude(), CONSTRAINT_MAPPER.mapRealInterval(unitValue.getValidation().getRange()));
        }
        return List.of();
    }

    private List<ConstraintViolation> validatePrecision(String path, DvQuantity quantity, WebTemplateInputValue unitValue) {
        if (WebTemplateValidationUtils.hasValidationPrecision(unitValue) && quantity.getPrecision() != null) {
            return PrimitiveConstraintValidator.validate(path, (Object)quantity.getPrecision(), CONSTRAINT_MAPPER.mapIntegerInterval(unitValue.getValidation().getPrecision()));
        }
        return List.of();
    }
}

