/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.nedap.archie.rm.datavalues.quantity.DvQuantified;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.List;
import org.ehrbase.openehr.sdk.serialisation.walker.DurationHelper;
import org.ehrbase.openehr.sdk.validation.ConstraintViolation;
import org.ehrbase.openehr.sdk.validation.webtemplate.ConstraintValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateComparisonSymbol;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.threeten.extra.PeriodDuration;

public class DvDurationValidator
implements ConstraintValidator<DvDuration> {
    public Class<DvDuration> getAssociatedClass() {
        return DvDuration.class;
    }

    @Override
    public List<ConstraintViolation> validate(DvDuration dvDuration, WebTemplateNode node) {
        if (!WebTemplateValidationUtils.hasInputs(node)) {
            return List.of();
        }
        PeriodDuration duration = PeriodDuration.from((TemporalAmount)dvDuration.getValue());
        List<ConstraintViolation> result = List.of();
        for (DurationHelper.MIN_MAX m : DurationHelper.MIN_MAX.values()) {
            ConstraintViolation violation;
            WebTemplateComparisonSymbol s = DurationHelper.getTotalComparisonSymbol((WebTemplateNode)node, (DurationHelper.MIN_MAX)m);
            if (s == null || (violation = this.validate(node, duration, s, (TemporalAmount)DurationHelper.buildTotalRange((WebTemplateNode)node, (DurationHelper.MIN_MAX)m).orElse(PeriodDuration.ZERO))) == null) continue;
            result = ConstraintValidator.concat(result, List.of(violation));
        }
        return result;
    }

    private ConstraintViolation validate(WebTemplateNode node, PeriodDuration duration, WebTemplateComparisonSymbol symbol, TemporalAmount range) {
        boolean valid;
        int durationCmp = new DvDuration((TemporalAmount)duration).compareTo((DvQuantified)new DvDuration(range));
        switch (symbol) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case GT_EQ: {
                boolean bl;
                if (durationCmp >= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case GT: {
                boolean bl;
                if (durationCmp > 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case LT_EQ: {
                boolean bl;
                if (durationCmp <= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case LT: {
                boolean bl = valid = durationCmp < 0;
            }
        }
        if (valid) {
            return null;
        }
        return new ConstraintViolation(node.getAqlPath(), String.format("The value %s must be %s %s", duration, symbol.getSymbol(), range));
    }

    private Long getValue(PeriodDuration duration, String unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be null");
        }
        switch (unit) {
            case "year": {
                return duration.get((TemporalUnit)ChronoUnit.YEARS);
            }
            case "month": {
                return duration.get((TemporalUnit)ChronoUnit.MONTHS);
            }
            case "day": {
                return duration.get((TemporalUnit)ChronoUnit.DAYS);
            }
            case "week": {
                return duration.get((TemporalUnit)ChronoUnit.DAYS) / 7L;
            }
            case "hour": {
                return duration.getDuration().toHoursPart();
            }
            case "minute": {
                return duration.getDuration().toMinutesPart();
            }
            case "second": {
                return duration.getDuration().toSecondsPart();
            }
        }
        throw new IllegalArgumentException("Unsupported unit: " + unit);
    }

    boolean isNegativ(PeriodDuration periodDuration) {
        return periodDuration.getPeriod().isNegative() || periodDuration.isZero() && periodDuration.getDuration().isNegative();
    }
}

