/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.query.RMPathQuery;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageIds;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.serialisation.walker.ItemExtractor;
import org.ehrbase.openehr.sdk.validation.ConstraintViolation;
import org.ehrbase.openehr.sdk.validation.webtemplate.ConstraintValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.model.WebtemplateCardinality;

public class DefaultValidator
implements ConstraintValidator<RMObject> {
    private final BiFunction<AqlPath, Function<AqlPath, RMPathQuery>, RMPathQuery> rmPathQueryCache;

    public DefaultValidator() {
        HashMap cache = new HashMap();
        this.rmPathQueryCache = cache::computeIfAbsent;
    }

    public Class<RMObject> getAssociatedClass() {
        return RMObject.class;
    }

    private RMPathQuery getRmPathQuery(AqlPath path) {
        return this.rmPathQueryCache.apply(path, ItemExtractor.AqlPathRMPathQuery::new);
    }

    private Stream<Object> itemsAtPath(AqlPath path, Pathable currentPathable) {
        return this.getRmPathQuery(path).findList((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), (Object)currentPathable).stream().map(RMObjectWithPath::getObject);
    }

    @Override
    public List<ConstraintViolation> validate(RMObject object, WebTemplateNode node) {
        if (node == null || !(object instanceof Locatable)) {
            return List.of();
        }
        Locatable locatable = (Locatable)object;
        return this.validate(locatable, node);
    }

    @Override
    private List<ConstraintViolation> validate(Locatable locatable, WebTemplateNode node) {
        List children = node.getChildren();
        List<ConstraintViolation> result = List.of();
        for (WebTemplateNode childNode : children) {
            ConstraintViolation violation = this.validateChild(locatable, node, childNode);
            if (violation == null) continue;
            result = ConstraintValidator.concat(result, List.of(violation));
        }
        return result;
    }

    private ConstraintViolation validateChild(Locatable locatable, WebTemplateNode node, WebTemplateNode childNode) {
        AqlPath relativePath = node.buildRelativePath(childNode, false);
        int count = (int)this.itemsAtPath(relativePath, (Pathable)locatable).filter(item -> {
            if (item instanceof Locatable) {
                Locatable loc = (Locatable)item;
                return Objects.equals(loc.getNameAsString(), childNode.getName()) || !WebTemplateNode.isNameDependent((AqlPath)relativePath);
            }
            return true;
        }).count();
        MultiplicityInterval interval = this.getMultiplicityInterval(childNode, node);
        if (interval.has((Object)count)) {
            return null;
        }
        String message = RMObjectValidationMessageIds.rm_OCCURRENCE_MISMATCH.getMessage(new Object[]{count, interval.toString()});
        return new ConstraintViolation(childNode.getAqlPath(), message);
    }

    private MultiplicityInterval getMultiplicityInterval(WebTemplateNode node, WebTemplateNode parentNode) {
        MultiplicityInterval interval = WebTemplateValidationUtils.getMultiplicityInterval(node);
        for (WebtemplateCardinality cardinality : parentNode.getCardinalities()) {
            if (!BooleanUtils.isTrue((Boolean)cardinality.getExcludeFromWebTemplate()) || !cardinality.getIds().contains(node.getId(false))) continue;
            interval.setLower((Object)cardinality.getMin());
            interval.setUpper((Object)cardinality.getMax());
            break;
        }
        return interval;
    }
}

