/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.terminology;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Pathable;
import java.lang.reflect.Field;
import java.util.List;
import org.ehrbase.openehr.sdk.terminology.openehr.TerminologyInterface;
import org.ehrbase.openehr.sdk.terminology.openehr.implementation.AttributeCodesetMapping;
import org.ehrbase.openehr.sdk.validation.terminology.ItemValidator;
import org.ehrbase.openehr.sdk.validation.terminology.validator.ItemField;

public class Pathables {
    private ItemValidator itemValidator;
    private TerminologyInterface terminologyInterface;
    private AttributeCodesetMapping codesetMapping;
    private String language;

    Pathables(TerminologyInterface terminologyInterface, AttributeCodesetMapping codesetMapping, ItemValidator itemValidator, String language) {
        this.terminologyInterface = terminologyInterface;
        this.itemValidator = itemValidator;
        this.codesetMapping = codesetMapping;
        this.language = language;
    }

    public void traverse(Pathable pathable, String ... excludes) throws IllegalArgumentException, InternalError {
        for (Field field : pathable.getClass().getDeclaredFields()) {
            if (!field.getType().equals(List.class)) {
                try {
                    if (field.getType() != field.getType().asSubclass(Pathable.class) || this.isFieldExcluded(excludes, field.getName())) continue;
                    RMObject object = (RMObject)new ItemField(pathable).objectForField(field);
                    if (object instanceof Pathable) {
                        new Pathables(this.terminologyInterface, this.codesetMapping, this.itemValidator, this.language).traverse((Pathable)object, excludes);
                        continue;
                    }
                    if (object == null) continue;
                    throw new IllegalArgumentException("Internal: couldn't handle object retrieved using getter");
                }
                catch (ClassCastException e) {
                    if (!this.itemValidator.isValidatedRmObjectType(field.getType())) continue;
                    RMObject object = (RMObject)new ItemField(pathable).objectForField(field);
                    this.itemValidator.validate(this.terminologyInterface, this.codesetMapping, field.getName(), object, this.language);
                }
                continue;
            }
            List iterable = (List)new ItemField(pathable).objectForField(field);
            for (Object item : iterable) {
                if (item instanceof RMObject) {
                    this.itemValidator.validate(this.terminologyInterface, this.codesetMapping, field.getName(), (RMObject)item, this.language);
                    continue;
                }
                if (item instanceof Pathable) {
                    this.traverse((Pathable)item, excludes);
                    continue;
                }
                throw new IllegalStateException("Could not handle item in list:" + item);
            }
        }
    }

    private boolean isFieldExcluded(String[] excludes, String fieldName) {
        for (String exclude : excludes) {
            if (!exclude.equals(fieldName)) continue;
            return true;
        }
        return false;
    }
}

