/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.terminology;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datavalues.quantity.DvOrdered;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.openehr.sdk.terminology.openehr.TerminologyInterface;
import org.ehrbase.openehr.sdk.terminology.openehr.implementation.AttributeCodesetMapping;
import org.ehrbase.openehr.sdk.validation.terminology.ValidationHandler;
import org.ehrbase.openehr.sdk.validation.terminology.validator.I_TerminologyCheck;

public class ItemValidator {
    private Map<String, ValidationHandler> validationRegistryList = new HashMap<String, ValidationHandler>();

    ItemValidator() {
    }

    public ItemValidator add(I_TerminologyCheck validator) throws NoSuchMethodException, IllegalAccessException, InternalError {
        Class rmClass = validator.rmClass();
        if (rmClass == null) {
            throw new IllegalStateException("Internal error:" + validator.getClass() + " does not define a matching RM class! (hint: RM_CLASS must be defined in validator class)");
        }
        MethodHandle methodHandle = MethodHandles.lookup().findStatic(validator.getClass(), "check", MethodType.methodType(Void.TYPE, new Class[]{TerminologyInterface.class, AttributeCodesetMapping.class, String.class, rmClass, String.class}));
        this.validationRegistryList.put(rmClass.getCanonicalName(), new ValidationHandler(rmClass, methodHandle));
        return this;
    }

    boolean isValidatedRmObjectType(RMObject rmObject) {
        if (!this.validationRegistryList.containsKey(rmObject.getClass().getCanonicalName())) {
            try {
                if (rmObject.getClass().equals(rmObject.getClass().asSubclass(DvOrdered.class))) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    boolean isValidatedRmObjectType(Class<?> aRmObjectClass) {
        if (!this.validationRegistryList.containsKey(aRmObjectClass.getCanonicalName())) {
            try {
                aRmObjectClass.asSubclass(DvOrdered.class);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private ValidationHandler matchValidator(RMObject rmObject) {
        String rmClassName = rmObject.getClass().getCanonicalName();
        return this.validationRegistryList.get(rmClassName);
    }

    private ValidationHandler matchValidator(Class<?> rmClass) {
        return this.validationRegistryList.get(rmClass.getCanonicalName());
    }

    public void validate(TerminologyInterface terminologyInterface, AttributeCodesetMapping codesetMapping, String fieldName, RMObject rmObject, String language) throws InternalError {
        if (rmObject == null) {
            return;
        }
        ValidationHandler validationHandler = this.matchValidator(rmObject);
        if (validationHandler == null) {
            try {
                if (rmObject.getClass().equals(rmObject.getClass().asSubclass(DvOrdered.class))) {
                    validationHandler = this.matchValidator(DvOrdered.class);
                }
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            if (validationHandler == null) {
                throw new IllegalStateException("No Validator for" + rmObject.getClass().getCanonicalName());
            }
            MethodHandle methodHandle = validationHandler.check();
            methodHandle.invoke(terminologyInterface, codesetMapping, fieldName, rmObject, language);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable.getMessage());
        }
    }
}

