/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation;

import com.nedap.archie.flattener.OperationalTemplateProvider;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rmobjectvalidator.RMObjectValidator;
import com.nedap.archie.rmobjectvalidator.ValidationConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ehrbase.openehr.sdk.validation.ArchetypeNeglectingRMObjectValidator;
import org.ehrbase.openehr.sdk.validation.ConstraintViolation;
import org.ehrbase.openehr.sdk.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.openehr.sdk.validation.webtemplate.FastRMObjectValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.ValidationWalker;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.parser.OPTParser;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;

public class CompositionValidator {
    private final boolean checkForChildrenNotInTemplate;
    private final RMObjectValidator rmObjectValidator;
    private ExternalTerminologyValidation externalTerminologyValidation;

    public CompositionValidator() {
        this(null, false, true, null);
    }

    public CompositionValidator(ExternalTerminologyValidation externalTerminologyValidation, boolean checkForChildrenNotInTemplate, boolean validateInvariants, OperationalTemplateProvider archetypeProvider) {
        this.externalTerminologyValidation = externalTerminologyValidation;
        this.checkForChildrenNotInTemplate = checkForChildrenNotInTemplate;
        ValidationConfiguration validationCfg = new ValidationConfiguration.Builder().validateInvariants(validateInvariants).failOnUnknownTerminologyId(false).build();
        this.rmObjectValidator = archetypeProvider != null ? new FastRMObjectValidator((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), archetypeProvider, validationCfg) : new ArchetypeNeglectingRMObjectValidator((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), archetypeId -> null, validationCfg);
    }

    public List<ConstraintViolation> validate(Composition composition, OPERATIONALTEMPLATE template) {
        return this.validate(composition, new OPTParser(template).parse());
    }

    public List<ConstraintViolation> validate(Composition composition, WebTemplate template) {
        List messages = this.rmObjectValidator.validate((Object)composition);
        if (messages.isEmpty()) {
            ArrayList<ConstraintViolation> result = new ArrayList<ConstraintViolation>();
            new ValidationWalker(this.externalTerminologyValidation, this.checkForChildrenNotInTemplate).walk((RMObject)composition, result, template.getTree(), template.getTemplateId());
            return result;
        }
        return messages.stream().map(validationMessage -> new ConstraintViolation(validationMessage.getPath(), validationMessage.getMessage())).collect(Collectors.toList());
    }

    public RMObjectValidator getRmObjectValidator() {
        return this.rmObjectValidator;
    }

    public void setExternalTerminologyValidation(ExternalTerminologyValidation externalTerminologyValidation) {
        this.externalTerminologyValidation = externalTerminologyValidation;
    }
}

