/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public interface Freezable<O extends Freezable<O>>
extends Cloneable {
    public O thawed();

    @JsonIgnore
    public boolean isFrozen();

    public O frozen();

    public O clone();

    public static <T extends Freezable<T>> List<T> thawed(List<T> list) {
        return list.stream().map(Freezable::thawed).collect(Collectors.toList());
    }

    public static <T extends Freezable<T>> List<T> clone(List<T> list) {
        return list.stream().map(Freezable::clone).collect(Collectors.toList());
    }

    public static <T extends Freezable<T>> List<T> frozen(List<T> list) {
        return list.stream().map(Freezable::frozen).toList();
    }

    public static <F extends Freezable<F>> F clone(F object, UnaryOperator<F> cloneOp) {
        return (F)((Freezable)Optional.of(object).filter(t -> !t.isFrozen()).map(cloneOp).orElse(object));
    }

    public static <F extends Freezable<F>> F frozen(F object, UnaryOperator<F> immutableCloneOp) {
        return (F)((Freezable)Optional.of(object).filter(t -> !t.isFrozen()).map(immutableCloneOp).orElse(object));
    }
}

