/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.util;

import java.nio.CharBuffer;
import org.apache.commons.lang3.StringUtils;

public class CharSequenceHelper {
    private CharSequenceHelper() {
    }

    public static CharSequence subSequence(CharSequence str, int beginIndex) {
        return CharSequenceHelper.subSequence(str, beginIndex, str.length());
    }

    public static CharSequence subSequence(CharSequence str, int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            return "";
        }
        if (beginIndex == 0 && endIndex == str.length()) {
            return str;
        }
        if (str.getClass() == String.class) {
            return CharBuffer.wrap(str, beginIndex, endIndex);
        }
        return str.subSequence(beginIndex, endIndex);
    }

    public static CharSequence removeStart(CharSequence str, String remove) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return str;
        }
        int removeLen = remove.length();
        if (strLen < removeLen) {
            return str;
        }
        if (0 == CharSequenceHelper.compareSubsequence(remove, 0, removeLen, str, 0, removeLen)) {
            return CharSequenceHelper.subSequence(str, removeLen, strLen);
        }
        return str;
    }

    public static CharSequence removeEnd(CharSequence str, String remove) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return str;
        }
        int removeLen = remove.length();
        if (strLen < removeLen) {
            return str;
        }
        int len = strLen - removeLen;
        if (0 == CharSequenceHelper.compareSubsequence(remove, 0, removeLen, str, len, strLen)) {
            return CharSequenceHelper.subSequence(str, 0, len);
        }
        return str;
    }

    public static CharSequence[] splitFirst(CharSequence str, char separator) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new CharSequence[0];
        }
        int pos = StringUtils.indexOf((CharSequence)str, (int)separator);
        if (pos < 0) {
            return new CharSequence[]{str};
        }
        int strLen = str.length();
        if (pos == 0) {
            if (strLen == 1) {
                return new CharSequence[0];
            }
            return new CharSequence[]{CharSequenceHelper.subSequence(str, 1, strLen)};
        }
        if (pos + 1 == strLen) {
            return new CharSequence[]{CharSequenceHelper.subSequence(str, 0, pos)};
        }
        return new CharSequence[]{CharSequenceHelper.subSequence(str, 0, pos), CharSequenceHelper.subSequence(str, pos + 1, strLen)};
    }

    public static int compareSubsequence(CharSequence cs1, int start1, int end1, CharSequence cs2, int start2, int end2) {
        if (cs1 == cs2 && start1 == start2) {
            return end1 - end2;
        }
        int len1 = end1 - start1;
        int len2 = end2 - start2;
        int len = Math.min(len1, len2);
        if ((start1 & start2) == 0 && len == cs1.length() && len == cs2.length()) {
            return CharSequence.compare(cs1, cs2);
        }
        int p1 = start1;
        int p2 = start2;
        int e1 = start1 + len;
        while (p1 < e1) {
            char b;
            char a = cs1.charAt(p1);
            if (a != (b = cs2.charAt(p2))) {
                return a - b;
            }
            ++p1;
            ++p2;
        }
        return len1 - len2;
    }

    public static CharSequence trim(CharSequence value) {
        int st;
        int length;
        int len = length = value.length();
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        while (st < len && value.charAt(len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < length ? CharSequenceHelper.subSequence(value, st, len) : value;
    }
}

