/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.QueryParameter;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate.DisjunctablePredicate;
import org.ehrbase.openehr.sdk.util.exception.SdkException;

public final class PredicateComparisonOperator
implements DisjunctablePredicate,
Serializable {
    private final String statement;
    private final ComparisonOperatorSymbol symbol;
    private final PathPredicateOperand value;

    public PredicateComparisonOperator(PredicateComparisonOperator other) {
        this.statement = other.statement;
        this.symbol = other.symbol;
        if (other.value instanceof QueryParameter) {
            this.value = new QueryParameter((QueryParameter)other.value);
        } else {
            try {
                this.value = (PathPredicateOperand)other.getValue().getClass().getConstructor(Primitive.class).newInstance(((Primitive)other.value).getValue());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new SdkException(e.getMessage());
            }
        }
    }

    public PredicateComparisonOperator(String statement, ComparisonOperatorSymbol symbol, PathPredicateOperand value) {
        this.statement = statement;
        this.symbol = symbol;
        this.value = value;
    }

    public String getStatement() {
        return this.statement;
    }

    public ComparisonOperatorSymbol getSymbol() {
        return this.symbol;
    }

    public PathPredicateOperand getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredicateComparisonOperator)) {
            return false;
        }
        PredicateComparisonOperator other = (PredicateComparisonOperator)o;
        if (!Objects.equals(this.getStatement(), other.getStatement())) {
            return false;
        }
        if (!Objects.equals((Object)this.getSymbol(), (Object)other.getSymbol())) {
            return false;
        }
        return Objects.equals(this.getValue(), other.getValue());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $statement = this.getStatement();
        result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
        ComparisonOperatorSymbol $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : ((Object)((Object)$symbol)).hashCode());
        PathPredicateOperand $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "ComparisonOperatorCondition(statement=" + this.getStatement() + ", symbol=" + this.getSymbol() + ", value=" + this.getValue() + ")";
    }
}

