/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.render;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.ExistsCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LikeCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LogicalOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.MatchesCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.NotCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.WhereCondition;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentNotOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentVersionExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.AggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.ColumnExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.ComparisonLeftOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.CountDistinctAggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.DoublePrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.LikeOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.MatchesOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Operand;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.QueryParameter;
import org.ehrbase.openehr.sdk.aql.dto.operand.SingleRowFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.TerminologyFunction;
import org.ehrbase.openehr.sdk.aql.dto.orderby.OrderByExpression;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPathUtil;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectClause;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectExpression;
import org.ehrbase.openehr.sdk.util.exception.SdkException;

public final class AqlRenderer {
    private AqlRenderer() {
    }

    public static String render(AqlQuery dto) {
        StringBuilder sb = new StringBuilder();
        AqlRenderer.renderSelect(sb, dto.getSelect());
        AqlRenderer.renderFromClause(sb, dto.getFrom());
        if (dto.getWhere() != null) {
            sb.append(" WHERE ");
            AqlRenderer.renderWhere(sb, dto.getWhere());
        }
        if (CollectionUtils.isNotEmpty(dto.getOrderBy())) {
            AqlRenderer.renderOrderByClause(sb, dto.getOrderBy());
        }
        if (dto.getLimit() != null) {
            sb.append(" LIMIT ").append(dto.getLimit());
            if (dto.getOffset() != null) {
                sb.append(" OFFSET ").append(dto.getOffset());
            }
        }
        return sb.toString();
    }

    public static String render(IdentifiedPath ip) {
        StringBuilder sb = new StringBuilder();
        AqlRenderer.renderIdentifiedPath(sb, ip);
        return sb.toString();
    }

    public static String render(AqlObjectPath p) {
        StringBuilder sb = new StringBuilder();
        AqlRenderer.renderPath(sb, p);
        return sb.toString();
    }

    private static void renderOrderByClause(StringBuilder sb, List<OrderByExpression> orderBy) {
        sb.append(" ORDER BY ");
        Iterator<OrderByExpression> it = orderBy.iterator();
        while (it.hasNext()) {
            OrderByExpression next = it.next();
            AqlRenderer.renderIdentifiedPath(sb, next.getStatement());
            sb.append(" ").append((Object)next.getSymbol());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
    }

    private static void renderWhere(StringBuilder sb, WhereCondition where) {
        if (where instanceof ComparisonOperatorCondition) {
            ComparisonOperatorCondition comparisonOperatorCondition = (ComparisonOperatorCondition)where;
            AqlRenderer.renderConditionComparisonOperatorDto(sb, comparisonOperatorCondition);
        } else if (where instanceof NotCondition) {
            NotCondition notCondition = (NotCondition)where;
            AqlRenderer.renderNotConditionOperatorDto(sb, notCondition);
        } else if (where instanceof ExistsCondition) {
            ExistsCondition existsCondition = (ExistsCondition)where;
            AqlRenderer.renderExistsCondition(sb, existsCondition);
        } else if (where instanceof LogicalOperatorCondition) {
            LogicalOperatorCondition logicalOperatorCondition = (LogicalOperatorCondition)where;
            AqlRenderer.renderConditionLogical(sb, logicalOperatorCondition);
        } else if (where instanceof LikeCondition) {
            LikeCondition likeCondition = (LikeCondition)where;
            AqlRenderer.renderLike(sb, likeCondition);
        } else if (where instanceof MatchesCondition) {
            MatchesCondition matchesCondition = (MatchesCondition)where;
            AqlRenderer.renderMatches(sb, matchesCondition);
        } else {
            throw new SdkException("Cannot handle %s".formatted(where.getClass().getName()));
        }
    }

    private static void renderMatches(StringBuilder sb, MatchesCondition matchesCondition) {
        AqlRenderer.renderIdentifiedPath(sb, matchesCondition.getStatement());
        sb.append(" ").append("MATCHES").append(" ");
        sb.append("{");
        Iterator<MatchesOperand> iterator = matchesCondition.getValues().iterator();
        while (iterator.hasNext()) {
            MatchesOperand next = iterator.next();
            AqlRenderer.renderMatchesOperand(sb, next);
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
    }

    private static void renderMatchesOperand(StringBuilder sb, MatchesOperand next) {
        if (next instanceof QueryParameter) {
            QueryParameter queryParameter = (QueryParameter)next;
            AqlRenderer.renderParameterDto(sb, queryParameter);
        } else if (next instanceof Primitive) {
            Primitive primitive = (Primitive)next;
            sb.append(AqlRenderer.renderPrimitive(primitive));
        } else if (next instanceof TerminologyFunction) {
            TerminologyFunction terminologyFunction = (TerminologyFunction)next;
            AqlRenderer.renderTerminologyFunction(sb, terminologyFunction);
        } else {
            throw new SdkException("Cannot handle %s".formatted(next.getClass().getName()));
        }
    }

    private static void renderTerminologyFunction(StringBuilder sb, TerminologyFunction terminologyFunction) {
        sb.append("TERMINOLOGY").append("(").append(AqlRenderer.encodeString(terminologyFunction.getOperation())).append(",").append(AqlRenderer.encodeString(terminologyFunction.getServiceApi())).append(",").append(AqlRenderer.encodeString(terminologyFunction.getUriParameters())).append(")");
    }

    private static void renderLike(StringBuilder sb, LikeCondition likeCondition) {
        AqlRenderer.renderIdentifiedPath(sb, likeCondition.getStatement());
        sb.append(" LIKE ");
        AqlRenderer.renderLikeOperand(sb, likeCondition.getValue());
    }

    private static void renderLikeOperand(StringBuilder sb, LikeOperand value) {
        if (value instanceof QueryParameter) {
            QueryParameter queryParameter = (QueryParameter)value;
            AqlRenderer.renderParameterDto(sb, queryParameter);
        } else {
            sb.append(AqlRenderer.renderPrimitive((StringPrimitive)value));
        }
    }

    private static void renderConditionLogical(StringBuilder sb, LogicalOperatorCondition logicalOperatorCondition) {
        Iterator<WhereCondition> iterator = logicalOperatorCondition.getValues().iterator();
        sb.append("(");
        while (iterator.hasNext()) {
            AqlRenderer.renderWhere(sb, iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(" ").append((Object)logicalOperatorCondition.getSymbol()).append(" ");
        }
        sb.append(")");
    }

    private static void renderExistsCondition(StringBuilder sb, ExistsCondition existsCondition) {
        sb.append("EXISTS ");
        AqlRenderer.renderIdentifiedPath(sb, existsCondition.getValue());
    }

    private static void renderNotConditionOperatorDto(StringBuilder sb, NotCondition notCondition) {
        sb.append("NOT ");
        AqlRenderer.renderWhere(sb, notCondition.getConditionDto());
    }

    private static void renderConditionComparisonOperatorDto(StringBuilder sb, ComparisonOperatorCondition comparisonOperatorCondition) {
        ComparisonLeftOperand statement = comparisonOperatorCondition.getStatement();
        AqlRenderer.renderComparisonLeftOperator(sb, statement);
        sb.append(" ").append(comparisonOperatorCondition.getSymbol().getSymbol()).append(" ");
        sb.append(AqlRenderer.renderTerminal(comparisonOperatorCondition.getValue()));
    }

    private static void renderComparisonLeftOperator(StringBuilder sb, ComparisonLeftOperand statement) {
        if (statement instanceof IdentifiedPath) {
            IdentifiedPath identifiedPath = (IdentifiedPath)statement;
            AqlRenderer.renderIdentifiedPath(sb, identifiedPath);
        } else if (statement instanceof SingleRowFunction) {
            SingleRowFunction singleRowFunktion = (SingleRowFunction)statement;
            AqlRenderer.renderSingleRowFunctionDto(sb, singleRowFunktion);
        } else if (statement instanceof TerminologyFunction) {
            TerminologyFunction terminologyFunction = (TerminologyFunction)statement;
            AqlRenderer.renderTerminologyFunction(sb, terminologyFunction);
        } else {
            throw new SdkException("Cannot handle %s".formatted(statement.getClass().getName()));
        }
    }

    private static void renderSelect(StringBuilder sb, SelectClause dto) {
        sb.append("SELECT ");
        if (dto.isDistinct()) {
            sb.append("DISTINCT ");
        }
        Iterator it = dto.getStatement().stream().iterator();
        while (it.hasNext()) {
            AqlRenderer.renderSelectStatementDto(sb, (SelectExpression)it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(" ");
    }

    private static void renderSelectStatementDto(StringBuilder sb, SelectExpression dto) {
        ColumnExpression columnExpression = dto.getColumnExpression();
        if (columnExpression instanceof IdentifiedPath) {
            AqlRenderer.renderIdentifiedPath(sb, (IdentifiedPath)columnExpression);
        } else if (columnExpression instanceof Primitive) {
            AqlRenderer.renderSelectPrimitiveDto(sb, (Primitive)columnExpression);
        } else if (columnExpression instanceof AggregateFunction) {
            AqlRenderer.renderAggregateFunctionDto(sb, (AggregateFunction)columnExpression);
        } else if (columnExpression instanceof SingleRowFunction) {
            SingleRowFunction singleRowFunktion = (SingleRowFunction)columnExpression;
            AqlRenderer.renderSingleRowFunctionDto(sb, singleRowFunktion);
        } else {
            throw new UnsupportedOperationException("Cannot handle %s".formatted(dto.getClass().getName()));
        }
        if (dto.getAlias() != null) {
            sb.append(" AS ").append(dto.getAlias());
        }
    }

    private static void renderAggregateFunctionDto(StringBuilder sb, AggregateFunction aggregateFunction) {
        sb.append(aggregateFunction.getFunctionName().name()).append("(");
        if (aggregateFunction instanceof CountDistinctAggregateFunction) {
            if (aggregateFunction.getIdentifiedPath() == null) {
                throw new IllegalStateException("COUNT(DISTINCT *) is not allowed");
            }
            sb.append("DISTINCT ");
        }
        if (AggregateFunction.AggregateFunctionName.COUNT.equals((Object)aggregateFunction.getFunctionName()) && aggregateFunction.getIdentifiedPath() == null) {
            sb.append('*');
        } else {
            AqlRenderer.renderIdentifiedPath(sb, aggregateFunction.getIdentifiedPath());
        }
        sb.append(")");
    }

    private static void renderSingleRowFunctionDto(StringBuilder sb, SingleRowFunction singleRowFunktion) {
        sb.append(singleRowFunktion.getFunctionName().getName()).append("(");
        sb.append(singleRowFunktion.getOperandList().stream().map(AqlRenderer::renderTerminal).collect(Collectors.joining(", ")));
        sb.append(")");
    }

    private static String renderTerminal(Operand operand) {
        StringBuilder sb = new StringBuilder();
        if (operand instanceof SingleRowFunction) {
            SingleRowFunction singleRowFunktion = (SingleRowFunction)operand;
            AqlRenderer.renderSingleRowFunctionDto(sb, singleRowFunktion);
        } else if (operand instanceof IdentifiedPath) {
            IdentifiedPath identifiedPath = (IdentifiedPath)operand;
            AqlRenderer.renderIdentifiedPath(sb, identifiedPath);
        } else if (operand instanceof Primitive) {
            Primitive primitive = (Primitive)operand;
            sb.append(AqlRenderer.renderPrimitive(primitive));
        } else if (operand instanceof QueryParameter) {
            QueryParameter queryParameter = (QueryParameter)operand;
            AqlRenderer.renderParameterDto(sb, queryParameter);
        } else {
            throw new UnsupportedOperationException("Cannot handle %s".formatted(operand.getClass().getName()));
        }
        return sb.toString();
    }

    private static void renderParameterDto(StringBuilder sb, QueryParameter queryParameter) {
        sb.append("$").append(queryParameter.getName());
    }

    private static void renderIdentifiedPath(StringBuilder sb, IdentifiedPath dto) {
        AbstractContainmentExpression containmentDto = dto.getRoot();
        if (containmentDto == null) {
            throw new SdkException("SelectClause without corresponding contains");
        }
        sb.append(containmentDto.getIdentifier());
        Optional.of(dto).map(IdentifiedPath::getRootPredicate).ifPresent(p -> AqlRenderer.renderPredicate(sb, p));
        Optional.of(dto).map(IdentifiedPath::getPath).ifPresent(p -> {
            sb.append('/');
            AqlRenderer.renderPath(sb, p);
        });
    }

    public static String renderPredicate(List<AndOperatorPredicate> or) {
        StringBuilder sb = new StringBuilder();
        AqlRenderer.renderPredicate(sb, or);
        return sb.toString();
    }

    private static void renderPredicate(StringBuilder sb, List<AndOperatorPredicate> or) {
        if (or.isEmpty() || or.size() == 1 && or.get(0).isEmpty()) {
            return;
        }
        AqlRenderer.join(sb, " OR ", "[", "]", or.stream().map(a -> s -> AqlRenderer.renderPredicateAnd(s, a)));
    }

    private static void renderPredicateAnd(StringBuilder sb, AndOperatorPredicate and) {
        String prefix;
        if (and.isEmpty()) {
            throw new UnsupportedOperationException("Found empty AndOperatorPredicate");
        }
        List<ComparisonOperatorPredicate> operands = and.getOperands();
        ComparisonOperatorPredicate archetypeNodeId = AqlRenderer.getSpecialPredicate(operands, AqlObjectPathUtil.ARCHETYPE_NODE_ID, true);
        if (archetypeNodeId != null) {
            if (operands.size() == 2) {
                ComparisonOperatorPredicate nameValue = AqlRenderer.getSpecialPredicate(operands, AqlObjectPathUtil.NAME_VALUE, true);
                if (nameValue != null) {
                    AqlRenderer.appendPlainValue(sb, archetypeNodeId);
                    sb.append(", ");
                    AqlRenderer.renderPathPredicateOperand(sb, nameValue.getValue());
                    return;
                }
            } else if (operands.size() == 3) {
                ComparisonOperatorPredicate nameTerminologyId = AqlRenderer.getSpecialPredicate(operands, AqlObjectPathUtil.NAME_TERMINOLOGY, false);
                ComparisonOperatorPredicate nameCodeString = AqlRenderer.getSpecialPredicate(operands, AqlObjectPathUtil.NAME_CODE_STRING, false);
                if (ObjectUtils.allNotNull((Object[])new Object[]{nameTerminologyId, nameCodeString})) {
                    AqlRenderer.appendPlainValue(sb, archetypeNodeId);
                    sb.append(", ");
                    AqlRenderer.appendPlainValue(sb, nameTerminologyId);
                    sb.append("::");
                    AqlRenderer.appendPlainValue(sb, nameCodeString);
                    return;
                }
            }
        }
        if (archetypeNodeId != null) {
            AqlRenderer.appendPlainValue(sb, archetypeNodeId);
            prefix = " AND ";
        } else {
            prefix = "";
        }
        Stream<ComparisonOperatorPredicate> stream = and.getOperands().stream().filter(a -> a != archetypeNodeId);
        AqlRenderer.join(sb, " AND ", prefix, "", stream.map(a -> s -> AqlRenderer.renderComparisonPredicate(s, a)));
    }

    private static void appendPlainValue(StringBuilder sb, ComparisonOperatorPredicate predicate) {
        PathPredicateOperand<?> value = predicate.getValue();
        if (value instanceof StringPrimitive) {
            StringPrimitive sp = (StringPrimitive)value;
            sb.append((String)sp.getValue());
        } else if (value instanceof QueryParameter) {
            QueryParameter qp = (QueryParameter)value;
            sb.append("$").append(qp.getName());
        }
    }

    private static ComparisonOperatorPredicate getSpecialPredicate(List<ComparisonOperatorPredicate> operands, AqlObjectPath path, boolean parameterAllowed) {
        return operands.stream().filter(op -> AqlRenderer.isSpecialPredicate(op, path, parameterAllowed)).findFirst().orElse(null);
    }

    private static boolean isSpecialPredicate(ComparisonOperatorPredicate operand, AqlObjectPath path, boolean parameterAllowed) {
        return Optional.of(operand).filter(op -> op.getOperator() == ComparisonOperatorPredicate.PredicateComparisonOperator.EQ).filter(op -> path.equals(op.getPath())).filter(op -> op.getValue() instanceof StringPrimitive || parameterAllowed && AqlRenderer.isParameter(op)).isPresent();
    }

    private static boolean isParameter(ComparisonOperatorPredicate op) {
        return op.getValue() instanceof QueryParameter;
    }

    private static void join(StringBuilder sb, String delimiter, String prefix, String suffix, Stream<Consumer<StringBuilder>> stream) {
        Iterator it = stream.iterator();
        if (!it.hasNext()) {
            return;
        }
        sb.append(prefix);
        ((Consumer)it.next()).accept(sb);
        while (it.hasNext()) {
            sb.append(delimiter);
            ((Consumer)it.next()).accept(sb);
        }
        sb.append(suffix);
    }

    private static void renderComparisonPredicate(StringBuilder sb, ComparisonOperatorPredicate predicate) {
        AqlRenderer.renderPath(sb, predicate.getPath());
        boolean comparingPaths = predicate.getValue() instanceof AqlObjectPath;
        if (comparingPaths) {
            sb.append(' ');
        }
        sb.append(predicate.getOperator().getSymbol());
        if (comparingPaths) {
            sb.append(' ');
        }
        if (predicate.getOperator() == ComparisonOperatorPredicate.PredicateComparisonOperator.MATCHES) {
            sb.append(predicate.getMatchesOperand().getEscapedRegex());
        } else {
            AqlRenderer.renderPathPredicateOperand(sb, predicate.getValue());
        }
    }

    private static void renderPathPredicateOperand(StringBuilder sb, PathPredicateOperand operand) {
        if (operand instanceof QueryParameter) {
            QueryParameter o = (QueryParameter)operand;
            AqlRenderer.renderParameterDto(sb, o);
        } else if (operand instanceof Primitive) {
            Primitive o = (Primitive)operand;
            sb.append(AqlRenderer.renderPrimitive(o));
        } else if (operand instanceof AqlObjectPath) {
            AqlObjectPath o = (AqlObjectPath)operand;
            AqlRenderer.renderPath(sb, o);
        } else {
            throw new UnsupportedOperationException("Unsupported operand type %s".formatted(operand.getClass()));
        }
    }

    private static void renderPath(StringBuilder sb, AqlObjectPath p) {
        if (p.getPathNodes().isEmpty()) {
            throw new UnsupportedOperationException("Found empty AqlObjectPath");
        }
        AqlRenderer.join(sb, "/", "", "", p.getPathNodes().stream().map(a -> s -> AqlRenderer.renderPathNode(s, a)));
    }

    private static void renderPathNode(StringBuilder sb, AqlObjectPath.PathNode n) {
        sb.append(n.getAttribute());
        AqlRenderer.renderPredicate(sb, n.getPredicateOrOperands());
    }

    private static void renderSelectPrimitiveDto(StringBuilder sb, Primitive dto) {
        sb.append(AqlRenderer.renderPrimitive(dto));
    }

    private static String renderPrimitive(Primitive primitive) {
        if (primitive.getValue() == null) {
            return "NULL";
        }
        if (primitive instanceof DoublePrimitive) {
            DoublePrimitive d = (DoublePrimitive)primitive;
            return d.getStringRepresentation();
        }
        if (primitive instanceof StringPrimitive) {
            StringPrimitive s = (StringPrimitive)primitive;
            return AqlRenderer.encodeString((String)s.getValue());
        }
        return primitive.getValue().toString();
    }

    static String encodeString(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length() + 5);
        sb.append("'");
        int l = value.length();
        block10: for (int i = 0; i < l; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\'': 
                case '\\': {
                    sb.append('\\').append(ch);
                    continue block10;
                }
                case '\u0007': {
                    sb.append('\\').append('a');
                    continue block10;
                }
                case '\b': {
                    sb.append('\\').append('b');
                    continue block10;
                }
                case '\f': {
                    sb.append('\\').append('f');
                    continue block10;
                }
                case '\n': {
                    sb.append('\\').append('n');
                    continue block10;
                }
                case '\r': {
                    sb.append('\\').append('r');
                    continue block10;
                }
                case '\t': {
                    sb.append('\\').append('t');
                    continue block10;
                }
                case '\u000b': {
                    sb.append('\\').append('v');
                    continue block10;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append("'");
        return sb.toString();
    }

    private static void renderFromClause(StringBuilder sb, Containment from) {
        sb.append("FROM ");
        AqlRenderer.renderContainmentExpresionDto(sb, from);
    }

    private static void renderContainmentExpresionDto(StringBuilder sb, Containment dto) {
        if (dto instanceof AbstractContainmentExpression) {
            AbstractContainmentExpression classExpressionDto = (AbstractContainmentExpression)dto;
            AqlRenderer.renderContainmentDto(sb, classExpressionDto);
        } else if (dto instanceof ContainmentSetOperator) {
            ContainmentSetOperator containmentSetOperator = (ContainmentSetOperator)dto;
            AqlRenderer.renderContainmentLogicalOperator(sb, containmentSetOperator);
        } else {
            throw new UnsupportedOperationException("Cannot handle %s".formatted(dto.getClass().getName()));
        }
    }

    private static void renderContainmentLogicalOperator(StringBuilder sb, ContainmentSetOperator containmentSetOperator) {
        Iterator<Containment> iterator = containmentSetOperator.getValues().iterator();
        sb.append("(");
        while (iterator.hasNext()) {
            Containment next = iterator.next();
            boolean requiresParenthesis = AqlRenderer.requiresParenthesis(next);
            if (requiresParenthesis) {
                sb.append('(');
            }
            AqlRenderer.renderContainmentExpresionDto(sb, next);
            if (requiresParenthesis) {
                sb.append(')');
            }
            if (!iterator.hasNext()) continue;
            sb.append(" ").append((Object)containmentSetOperator.getSymbol()).append(" ");
        }
        sb.append(")");
    }

    private static boolean requiresParenthesis(Containment c) {
        AbstractContainmentExpression e;
        return c instanceof AbstractContainmentExpression && (e = (AbstractContainmentExpression)c).getContains() != null;
    }

    private static void renderContainmentDto(StringBuilder sb, AbstractContainmentExpression dto) {
        if (dto instanceof ContainmentClassExpression) {
            ContainmentClassExpression classExpression = (ContainmentClassExpression)dto;
            sb.append(classExpression.getType());
        } else {
            sb.append("VERSION");
        }
        if (dto.getIdentifier() != null) {
            sb.append(" ").append(dto.getIdentifier());
        }
        if (dto instanceof ContainmentClassExpression) {
            ContainmentClassExpression classExpression = (ContainmentClassExpression)dto;
            Optional.of(classExpression).map(ContainmentClassExpression::getPredicates).ifPresent(p -> AqlRenderer.renderPredicate(sb, p));
        } else if (dto instanceof ContainmentVersionExpression) {
            ContainmentVersionExpression versionExpression = (ContainmentVersionExpression)dto;
            switch (versionExpression.getVersionPredicateType()) {
                case NONE: {
                    break;
                }
                case LATEST_VERSION: {
                    sb.append("[LATEST_VERSION]");
                    break;
                }
                case ALL_VERSIONS: {
                    sb.append("[ALL_VERSIONS]");
                    break;
                }
                case STANDARD_PREDICATE: {
                    AqlRenderer.renderPredicate(sb, versionExpression.getPredicates());
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported type: " + dto.getClass().getName());
        }
        if (dto.getContains() != null) {
            Containment containment = dto.getContains();
            if (containment instanceof ContainmentNotOperator) {
                ContainmentNotOperator containmentNotOperator = (ContainmentNotOperator)containment;
                sb.append(" NOT CONTAINS ");
                AqlRenderer.renderContainmentExpresionDto(sb, containmentNotOperator.getContainmentExpression());
            } else {
                sb.append(" CONTAINS ");
                AqlRenderer.renderContainmentExpresionDto(sb, dto.getContains());
            }
        }
    }
}

