/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.object.tx.TransactionID;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicLong;

public class TransactionSource {
    private final AtomicLong current = new AtomicLong(1L);
    private volatile TransactionID oldestCache = new TransactionID(1L);
    private long retiredBase = 1L;
    private int retirePosition = 0;
    private final long GC_THRESHOLD = 32768L;
    private BitSet retired = new BitSet();

    public TransactionID create() {
        return new TransactionID(this.current.getAndIncrement());
    }

    public TransactionID oldest() {
        return this.oldestCache;
    }

    private void updateOldest() {
        this.retirePosition = this.retired.nextClearBit(this.retirePosition);
        long transactionId = (long)this.retirePosition + this.retiredBase;
        if (this.oldestCache.toLong() != transactionId) {
            this.oldestCache = new TransactionID(transactionId);
        }
    }

    private void gc() {
        if ((long)this.retirePosition > 32768L) {
            this.retiredBase += (long)this.retirePosition;
            this.retired = this.retired.get(this.retirePosition, this.retired.size());
            this.retirePosition = 0;
        }
    }

    public synchronized boolean retire(TransactionID txnId) {
        int index = (int)(txnId.toLong() - this.retiredBase);
        boolean last = !this.retired.get(index);
        this.retired.set(index);
        this.updateOldest();
        this.gc();
        return last;
    }
}

