/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats;

import com.tc.management.AbstractTerracottaMBean;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;

public abstract class AbstractNotifyingMBean
extends AbstractTerracottaMBean {
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private long nextSequenceNumber = 1L;

    protected AbstractNotifyingMBean(Class<?> mBeanInterface) throws NotCompliantMBeanException {
        super(mBeanInterface, true);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    protected synchronized void sendNotification(String type, Object source) {
        this.sendNotification(new Notification(type, source, this.nextSequenceNumber++));
    }

    protected synchronized void sendNotification(String msg, String attr, String type, Object oldVal, Object newVal) {
        this.sendNotification(new AttributeChangeNotification(this, this.nextSequenceNumber++, System.currentTimeMillis(), msg, attr, type, oldVal, newVal));
    }

    protected synchronized void sendNotification(String type, Object source, String message) {
        this.sendNotification(new Notification(type, source, this.nextSequenceNumber++, message));
    }

    protected synchronized void sendNotification(String type, Object source, Object userData) {
        Notification notification = new Notification(type, source, this.nextSequenceNumber++);
        notification.setUserData(userData);
        this.sendNotification(notification);
    }

    static {
        String[] types = new String[]{"jmx.attribute.change"};
        String noticeType = AttributeChangeNotification.class.getName();
        String description = "An attribute of this MBean has changed";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, noticeType, "An attribute of this MBean has changed")};
    }
}

