/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.internal.messages.ConcurrentEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.store.Chain;

public abstract class ServerStoreOpMessage
extends EhcacheOperationMessage {
    protected UUID clientId;
    protected long id = -1L;

    @Override
    public UUID getClientId() {
        if (this.clientId == null) {
            throw new AssertionError((Object)("Client Id is not supported for message type " + (Object)((Object)this.getMessageType())));
        }
        return this.clientId;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    private ServerStoreOpMessage() {
    }

    public static class ClearMessage
    extends ServerStoreOpMessage {
        ClearMessage(UUID clientId) {
            this.clientId = clientId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLEAR;
        }
    }

    public static class ClientInvalidationAllAck
    extends ServerStoreOpMessage {
        private final int invalidationId;

        ClientInvalidationAllAck(int invalidationId) {
            this.invalidationId = invalidationId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLIENT_INVALIDATION_ALL_ACK;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }
    }

    public static class ClientInvalidationAck
    extends KeyBasedServerStoreOpMessage {
        private final int invalidationId;

        ClientInvalidationAck(long key, int invalidationId) {
            super(key);
            this.invalidationId = invalidationId;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLIENT_INVALIDATION_ACK;
        }
    }

    public static class ReplaceAtHeadMessage
    extends KeyBasedServerStoreOpMessage {
        private final Chain expect;
        private final Chain update;

        ReplaceAtHeadMessage(long key, Chain expect, Chain update, UUID clientId) {
            super(key);
            this.expect = expect;
            this.update = update;
            this.clientId = clientId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.REPLACE;
        }

        public Chain getExpect() {
            return this.expect;
        }

        public Chain getUpdate() {
            return this.update;
        }
    }

    public static class AppendMessage
    extends KeyBasedServerStoreOpMessage {
        private final ByteBuffer payload;

        AppendMessage(long key, ByteBuffer payload, UUID clientId) {
            super(key);
            this.payload = payload;
            this.clientId = clientId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.APPEND;
        }

        public ByteBuffer getPayload() {
            return this.payload;
        }
    }

    public static class GetAndAppendMessage
    extends KeyBasedServerStoreOpMessage {
        private final ByteBuffer payload;

        GetAndAppendMessage(long key, ByteBuffer payload, UUID clientId) {
            super(key);
            this.payload = payload;
            this.clientId = clientId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.GET_AND_APPEND;
        }

        public ByteBuffer getPayload() {
            return this.payload;
        }
    }

    public static class GetMessage
    extends KeyBasedServerStoreOpMessage {
        GetMessage(long key) {
            super(key);
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.GET_STORE;
        }
    }

    public static abstract class KeyBasedServerStoreOpMessage
    extends ServerStoreOpMessage
    implements ConcurrentEntityMessage {
        private final long key;

        KeyBasedServerStoreOpMessage(long key) {
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }

        @Override
        public long concurrencyKey() {
            return this.key;
        }
    }
}

