/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config;

import org.ehcache.clustered.client.config.ClusteredResourceType;
import org.ehcache.clustered.client.config.DedicatedClusteredResourcePool;
import org.ehcache.clustered.common.PoolAllocation;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.config.SizedResourcePoolImpl;

public class DedicatedClusteredResourcePoolImpl
extends SizedResourcePoolImpl<DedicatedClusteredResourcePool>
implements DedicatedClusteredResourcePool {
    private final String fromResource;

    public DedicatedClusteredResourcePoolImpl(String fromResource, long size, MemoryUnit unit) {
        super(ClusteredResourceType.Types.DEDICATED, size, (ResourceUnit)unit, true);
        this.fromResource = fromResource;
    }

    public ClusteredResourceType<DedicatedClusteredResourcePool> getType() {
        return (ClusteredResourceType)super.getType();
    }

    @Override
    public MemoryUnit getUnit() {
        return (MemoryUnit)super.getUnit();
    }

    @Override
    public String getFromResource() {
        return this.fromResource;
    }

    @Override
    public PoolAllocation getPoolAllocation() {
        return new PoolAllocation.Dedicated(this.getFromResource(), this.getUnit().toBytes(this.getSize()));
    }

    public void validateUpdate(ResourcePool newPool) {
        throw new UnsupportedOperationException("Updating CLUSTERED resource is not supported");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Pool {");
        sb.append(this.getSize());
        sb.append(' ');
        sb.append(this.getUnit());
        sb.append(' ');
        sb.append(this.getType());
        if (this.isPersistent()) {
            sb.append("(persistent)");
        }
        sb.append(' ');
        sb.append("from=");
        if (this.getFromResource() == null) {
            sb.append("N/A");
        } else {
            sb.append('\'').append(this.getFromResource()).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }
}

