/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.exception.TCInternalError;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.TCProtocolException;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.HealthCheckerProbeMessage;
import com.tc.net.protocol.transport.HealthCheckerProbeMessageFactory;
import com.tc.net.protocol.transport.TransportHandshakeError;
import com.tc.net.protocol.transport.TransportHandshakeMessage;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.TransportMessageImpl;
import com.tc.net.protocol.transport.WireProtocolHeader;

public class TransportMessageFactoryImpl
implements TransportHandshakeMessageFactory,
HealthCheckerProbeMessageFactory {
    @Override
    public HealthCheckerProbeMessage createPing(ConnectionID connectionId, TCConnection source) {
        return TransportMessageFactoryImpl.createNewMessage((byte)4, connectionId, null, source, false, 0, (short)4);
    }

    @Override
    public HealthCheckerProbeMessage createPingReply(ConnectionID connectionId, TCConnection source) {
        return TransportMessageFactoryImpl.createNewMessage((byte)5, connectionId, null, source, false, 0, (short)4);
    }

    @Override
    public HealthCheckerProbeMessage createTimeCheck(ConnectionID connectionId, TCConnection source) {
        return TransportMessageFactoryImpl.createNewMessage((byte)6, connectionId, null, source, false, 0, (short)4);
    }

    @Override
    public TransportHandshakeMessage createSyn(ConnectionID connectionId, TCConnection source, short stackLayerFlags, int callbackPort) {
        return TransportMessageFactoryImpl.createNewMessage((byte)1, connectionId, null, source, false, 0, (short)2, stackLayerFlags, callbackPort);
    }

    @Override
    public TransportHandshakeMessage createAck(ConnectionID connectionId, TCConnection source) {
        return TransportMessageFactoryImpl.createNewMessage((byte)2, connectionId, null, source, false, 0, -1);
    }

    @Override
    public TransportHandshakeMessage createSynAck(ConnectionID connectionId, TCConnection source, boolean isMaxConnectionsExceeded, int maxConnections, int callbackPort) {
        return TransportMessageFactoryImpl.createNewMessage((byte)3, connectionId, null, source, isMaxConnectionsExceeded, maxConnections, callbackPort);
    }

    @Override
    public TransportHandshakeMessage createSynAck(ConnectionID connectionId, TransportHandshakeError errorContext, TCConnection source, boolean isMaxConnectionsExceeded, int maxConnections) {
        return TransportMessageFactoryImpl.createNewMessage((byte)3, connectionId, errorContext, source, isMaxConnectionsExceeded, maxConnections, -1);
    }

    private static TransportMessageImpl createNewMessage(byte type, ConnectionID connectionId, TransportHandshakeError errorContext, TCConnection source, boolean isMaxConnectionsExceeded, int maxConnections, short protocol) {
        return TransportMessageFactoryImpl.createNewMessage(type, connectionId, errorContext, source, isMaxConnectionsExceeded, maxConnections, protocol, (short)-1, -1);
    }

    private static TransportMessageImpl createNewMessage(byte type, ConnectionID connectionId, TransportHandshakeError errorContext, TCConnection source, boolean isMaxConnectionsExceeded, int maxConnections, int callbackPort) {
        return TransportMessageFactoryImpl.createNewMessage(type, connectionId, errorContext, source, isMaxConnectionsExceeded, maxConnections, (short)2, (short)-1, callbackPort);
    }

    private static TransportMessageImpl createNewMessage(byte type, ConnectionID connectionId, TransportHandshakeError errorContext, TCConnection source, boolean isMaxConnectionsExceeded, int maxConnections, short protocol, short stackLayerFlags, int callbackPort) {
        TransportMessageImpl message;
        TCByteBufferOutputStream bbos = new TCByteBufferOutputStream();
        bbos.write(5);
        bbos.write(type);
        connectionId.writeTo(bbos);
        bbos.writeBoolean(isMaxConnectionsExceeded);
        bbos.writeInt(maxConnections);
        bbos.writeShort(stackLayerFlags);
        bbos.writeInt(callbackPort);
        bbos.writeBoolean(errorContext != null);
        if (errorContext != null) {
            short errorType = errorContext.getErrorType();
            bbos.writeShort(errorType);
            if (errorType == 3) {
                bbos.writeString(errorContext.getMessage());
            } else {
                bbos.writeString(errorContext.toString());
            }
        }
        if (type == 6) {
            bbos.writeLong(System.currentTimeMillis());
        }
        WireProtocolHeader header = new WireProtocolHeader();
        header.setProtocol(protocol);
        try {
            message = new TransportMessageImpl(source, header, bbos.toArray());
        }
        catch (TCProtocolException e) {
            throw new TCInternalError(e);
        }
        return message;
    }
}

