/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ehcache.clustered.common.internal.ClusteredEhcacheIdentity;
import org.ehcache.clustered.common.internal.messages.CodecUtil;
import org.ehcache.clustered.common.internal.messages.ReconnectMessage;

public class ReconnectMessageCodec {
    private static final byte CLIENT_ID_SIZE = 16;
    private static final byte ENTRY_SIZE = 4;
    private static final byte HASH_SIZE = 8;
    private static final byte CLEAR_IN_PROGRESS_STATUS_SIZE = 1;

    public byte[] encode(ReconnectMessage reconnectMessage) {
        int totalLength = 0;
        Set<String> caches = reconnectMessage.getAllCaches();
        ArrayList<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>();
        for (String cache : caches) {
            Set<Long> hashToInvalidate = reconnectMessage.getInvalidationsInProgress(cache);
            int sizeOfBuffer = 2 * cache.length() + 1 + hashToInvalidate.size() * 8 + 8;
            ByteBuffer encodedCache = ByteBuffer.allocate(sizeOfBuffer);
            encodedCache.putInt(cache.length());
            CodecUtil.putStringAsCharArray(encodedCache, cache);
            if (reconnectMessage.isClearInProgress(cache)) {
                encodedCache.put((byte)1);
            } else {
                encodedCache.put((byte)0);
            }
            encodedCache.putInt(hashToInvalidate.size());
            for (long hash : hashToInvalidate) {
                encodedCache.putLong(hash);
            }
            encodedCache.flip();
            byteBuffers.add(encodedCache);
            totalLength += sizeOfBuffer;
        }
        ByteBuffer encodedMsg = ByteBuffer.allocate(totalLength + 16);
        encodedMsg.put(ClusteredEhcacheIdentity.serialize(reconnectMessage.getClientId()));
        for (ByteBuffer byteBuffer : byteBuffers) {
            encodedMsg.put(byteBuffer);
        }
        return encodedMsg.array();
    }

    public ReconnectMessage decode(byte[] payload) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        long msb = byteBuffer.getLong();
        long lsb = byteBuffer.getLong();
        HashMap caches = new HashMap();
        HashSet<String> clearInProgressCache = new HashSet<String>();
        while (byteBuffer.hasRemaining()) {
            int cacheIdSize = byteBuffer.getInt();
            String cacheId = CodecUtil.getStringFromBuffer(byteBuffer, cacheIdSize);
            byte clearInProgress = byteBuffer.get();
            if (clearInProgress == 1) {
                clearInProgressCache.add(cacheId);
            }
            HashSet<Long> hashToInvalidate = new HashSet<Long>();
            int numOfHash = byteBuffer.getInt();
            for (int i = 0; i < numOfHash; ++i) {
                hashToInvalidate.add(byteBuffer.getLong());
            }
            caches.put(cacheId, hashToInvalidate);
        }
        ReconnectMessage reconnectMessage = new ReconnectMessage(new UUID(msb, lsb), caches.keySet());
        for (Map.Entry cacheEntry : caches.entrySet()) {
            if (clearInProgressCache.contains(cacheEntry.getKey())) {
                reconnectMessage.addClearInProgress((String)cacheEntry.getKey());
            }
            reconnectMessage.addInvalidationsInProgress((String)cacheEntry.getKey(), (Set)cacheEntry.getValue());
        }
        return reconnectMessage;
    }
}

